/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.config.ConfigHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1749;
import net.minecraft.class_1752;
import net.minecraft.class_1755;
import net.minecraft.class_1776;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2199;
import net.minecraft.class_2231;
import net.minecraft.class_2238;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2279;
import net.minecraft.class_2309;
import net.minecraft.class_2312;
import net.minecraft.class_2323;
import net.minecraft.class_2331;
import net.minecraft.class_2336;
import net.minecraft.class_2344;
import net.minecraft.class_2349;
import net.minecraft.class_2378;
import net.minecraft.class_2387;
import net.minecraft.class_2401;
import net.minecraft.class_2423;
import net.minecraft.class_2428;
import net.minecraft.class_2457;
import net.minecraft.class_2530;
import net.minecraft.class_2533;
import net.minecraft.class_2542;
import net.minecraft.class_2960;
import net.minecraft.class_3709;
import net.minecraft.class_3922;
import net.minecraft.class_4850;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_8162;
import net.minecraft.class_8170;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class ObjectToPermissionMap {
    private static final Map<class_2248, class_2960> BLOCK_TO_PERMISSION = new HashMap<class_2248, class_2960>();
    private static final Map<Predicate<class_2248>, Supplier<class_2960>> BLOCK_PERMISSION_BUILDER = new HashMap<Predicate<class_2248>, Supplier<class_2960>>();
    private static final Map<class_1792, class_2960> ITEM_TO_PERMISSION = new HashMap<class_1792, class_2960>();
    private static final Map<Predicate<class_1792>, Supplier<class_2960>> ITEM_PERMISSION_BUILDER = new HashMap<Predicate<class_1792>, Supplier<class_2960>>();
    private static final Map<class_1299<?>, class_2960> ENTITY_TO_PERMISSION = new HashMap();
    private static final Map<class_2248, class_2960> LEFT_CLICK_BLOCK_PERMISSION = new HashMap<class_2248, class_2960>();

    public static void reload(MinecraftServer server) {
        BLOCK_TO_PERMISSION.clear();
        ITEM_TO_PERMISSION.clear();
        ENTITY_TO_PERMISSION.clear();
        LEFT_CLICK_BLOCK_PERMISSION.clear();
        for (class_2248 block : class_7923.field_41175) {
            BLOCK_PERMISSION_BUILDER.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(block)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> BLOCK_TO_PERMISSION.put(block, (class_2960)sub.get()));
        }
        for (class_1792 item : class_7923.field_41178) {
            ITEM_PERMISSION_BUILDER.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(item)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> ITEM_TO_PERMISSION.put(item, (class_2960)sub.get()));
        }
        ObjectToPermissionMap.process(ConfigHandler.config.itemPermission, class_7923.field_41178, ITEM_TO_PERMISSION);
        ObjectToPermissionMap.process(ConfigHandler.config.blockPermission, class_7923.field_41175, BLOCK_TO_PERMISSION);
        ObjectToPermissionMap.process(ConfigHandler.config.entityPermission, class_7923.field_41177, ENTITY_TO_PERMISSION);
        ObjectToPermissionMap.process(ConfigHandler.config.leftClickBlockPermission, class_7923.field_41175, LEFT_CLICK_BLOCK_PERMISSION);
    }

    private static <T> void process(List<String> list, class_2378<T> registry, Map<T, class_2960> map) {
        for (String s : list) {
            String[] sub = s.split("-");
            boolean remove = sub[1].equals("NONE");
            if (s.startsWith("@")) {
                class_2960 res = class_2960.method_60654((String)sub[0].substring(1));
                ObjectToPermissionMap.processTag(res, registry, b -> {
                    if (remove) {
                        map.remove(b);
                    } else {
                        class_2960 id = BuiltinPermission.tryLegacy(sub[1]);
                        ClaimPermission perm = PermissionManager.INSTANCE.get(id);
                        if (perm == null) {
                            Flan.error("Configuring custom permission map: No such permission for {}", sub[1]);
                        }
                        map.put(b, id);
                    }
                });
                continue;
            }
            if (remove) {
                map.remove(registry.method_10223(class_2960.method_60654((String)sub[0])));
                continue;
            }
            class_2960 id = BuiltinPermission.tryLegacy(sub[1]);
            ClaimPermission perm = PermissionManager.INSTANCE.get(id);
            if (perm == null) {
                Flan.error("Configuring custom permission map: No such permission for {} {}", sub[1], id);
            }
            map.put(registry.method_10223(class_2960.method_60654((String)sub[0])), id);
        }
    }

    private static <T> void processTag(class_2960 tag, class_2378<T> registry, Consumer<T> action) {
        Optional<class_6885.class_6888> t = registry.method_40272().filter(p -> ((class_6862)p.getFirst()).comp_327().equals((Object)tag)).map(Pair::getSecond).findFirst();
        t.ifPresent(holders -> holders.forEach(i -> action.accept(i.comp_349())));
    }

    public static class_2960 getFromBlock(class_2248 block) {
        return BLOCK_TO_PERMISSION.get(block);
    }

    public static class_2960 getFromItem(class_1799 stack) {
        class_2960 perm = ITEM_TO_PERMISSION.get(stack.method_7909());
        if (perm == null && stack.method_57826(class_9334.field_52175)) {
            perm = BuiltinPermission.JUKEBOX;
        }
        return perm;
    }

    public static class_2960 getFromEntity(class_1299<?> entity) {
        return ENTITY_TO_PERMISSION.get(entity);
    }

    public static class_2960 getForLeftClickBlock(class_2248 block) {
        return LEFT_CLICK_BLOCK_PERMISSION.get(block);
    }

    public static void registerBlockPredicateMap(Predicate<class_2248> pred, Supplier<class_2960> perm) {
        BLOCK_PERMISSION_BUILDER.put(pred, perm);
    }

    public static void registerItemPredicateMap(Predicate<class_1792> pred, Supplier<class_2960> perm) {
        ITEM_PERMISSION_BUILDER.put(pred, perm);
    }

    static {
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2199, () -> BuiltinPermission.ANVIL);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2244, () -> BuiltinPermission.BED);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2238, () -> BuiltinPermission.BEACON);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2323, () -> BuiltinPermission.DOOR);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2349, () -> BuiltinPermission.FENCEGATE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2533, () -> BuiltinPermission.TRAPDOOR);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2401 || block instanceof class_2269, () -> BuiltinPermission.BUTTONLEVER);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2428, () -> BuiltinPermission.NOTEBLOCK);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2312 || block instanceof class_2457 || block instanceof class_2309, () -> BuiltinPermission.REDSTONE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2387, () -> BuiltinPermission.JUKEBOX);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2231, () -> BuiltinPermission.PRESSUREPLATE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2423, () -> BuiltinPermission.PORTAL);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2542 || block instanceof class_2344, () -> BuiltinPermission.TRAMPLE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_4850, () -> BuiltinPermission.TARGETBLOCK);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_3709 || block instanceof class_3922 || block instanceof class_2530 || block instanceof class_2279, () -> BuiltinPermission.PROJECTILES);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2336, () -> BuiltinPermission.ENDERCHEST);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_2331, () -> BuiltinPermission.ENCHANTMENTTABLE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof class_8170, () -> BuiltinPermission.ARCHAEOLOGY);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof class_1776, () -> BuiltinPermission.ENDERPEARL);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof class_1755, () -> BuiltinPermission.BUCKET);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item == class_1802.field_8301, () -> BuiltinPermission.ENDCRYSTALPLACE);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item == class_1802.field_8233, () -> BuiltinPermission.CHORUSFRUIT);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item == class_1802.field_17524, () -> BuiltinPermission.PLACE);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof class_1752, () -> BuiltinPermission.PLACE);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof class_1749, () -> BuiltinPermission.BOAT);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof class_8162, () -> BuiltinPermission.ARCHAEOLOGY);
    }
}

