/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import io.github.flemmli97.flan.api.data.IPlayerData;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.AllowedRegistryList;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.commands.CommandHelp;
import io.github.flemmli97.flan.commands.CommandHelpers;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.event.ItemInteractEvents;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.CustomInteractListScreenHandler;
import io.github.flemmli97.flan.gui.PersonalGroupScreenHandler;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.EnumEditMode;
import io.github.flemmli97.flan.player.OfflinePlayerData;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2178;
import net.minecraft.class_2191;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7066;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class CommandClaim {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, boolean dedicated) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"flan").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.reload", true))).executes(CommandClaim::reloadConfig))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.claim.create"))).then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(CommandClaim::addClaim)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2232.method_9441()).requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.claim.admin.create", true))).suggests((src, build) -> class_2172.method_9265(((class_2168)src.getSource()).method_9211().method_29435().stream().map(k -> k.method_29177().toString()).toList(), (SuggestionsBuilder)build)).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((src, build) -> class_2172.method_9265(Stream.concat(Stream.of("+Admin"), ((class_2168)src.getSource()).method_9211().method_3760().method_14571().stream().map(p -> p.method_5667().toString())).toList(), (SuggestionsBuilder)build)).executes(CommandClaim::addClaimAs)))))).then(class_2170.method_9247((String)"all").executes(CommandClaim::addClaimAll))).then(class_2170.method_9247((String)"rect").then(class_2170.method_9244((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandClaim.addClaimRect((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"x"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"z")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"expand").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.claim.create"))).then(class_2170.method_9244((String)"distance", (ArgumentType)IntegerArgumentType.integer()).executes(CommandClaim::expandClaim)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"menu").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.menu"))).executes(CommandClaim::openMenu))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setHome").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.home"))).executes(CommandClaim::setClaimHome))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"trapped").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.trapped"))).executes(CommandClaim::trapped))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"name").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.name"))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(CommandClaim::nameClaim)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unlockDrops").executes(CommandClaim::unlockDrops)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.unlock.all", true))).executes(CommandClaim::unlockDropsPlayers)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"personalGroups").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.personal"))).executes(CommandClaim::openPersonalGroups))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.info"))).executes(ctx -> CommandClaim.claimInfo((CommandContext<class_2168>)ctx, Claim.InfoType.ALL))).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((src, b) -> CommandHelpers.enumSuggestion(Claim.InfoType.class, b)).executes(CommandClaim::claimInfo)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"transferClaim").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.transfer"))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(CommandClaim::transferClaim)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.delete"))).executes(CommandClaim::deleteClaim))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"deleteAll").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.delete.all"))).executes(CommandClaim::deleteAllClaim))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"deleteSubClaim").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.delete.sub"))).executes(CommandClaim::deleteSubClaim))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"deleteAllSubClaims").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.delete.sub.all"))).executes(CommandClaim::deleteAllSubClaim))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.list"))).executes(CommandClaim::listClaims)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.list.all", true))).executes(cmd -> CommandClaim.listClaims((CommandContext<class_2168>)cmd, class_2191.method_9330((CommandContext)cmd, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"switchMode").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.claim.mode"))).executes(CommandClaim::switchClaimMode))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bypass").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.bypass.claim", true))).executes(CommandClaim::switchAdminMode))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"readGriefPrevention").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.read.griefprevention", true))).executes(CommandClaim::readGriefPreventionData))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setAdminClaim").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.admin.claim", true))).then(class_2170.method_9244((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(CommandClaim::toggleAdminClaim)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"listAdminClaims").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.admin.list", true))).executes(CommandClaim::listAdminClaims))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"adminDelete").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.admin.delete", true))).executes(CommandClaim::adminDelete)).then(class_2170.method_9247((String)"all").then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(CommandClaim::adminDeleteAll))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"giveClaimBlocks").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.admin.give", true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(CommandClaim::giveClaimBlocks))).then(class_2170.method_9247((String)"base").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandClaim.giveClaimBlocks((CommandContext<class_2168>)ctx, true))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"buy").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.sell", false))).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(CommandClaim::buyClaimBlocks)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"sell").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.buy", false))).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(CommandClaim::sellClaimBlocks)))).then(class_2170.method_9247((String)"claimMessage").then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> class_2172.method_9253((String[])new String[]{"enter", "leave"}, (SuggestionsBuilder)b)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"title", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> class_2172.method_9253((String[])new String[]{"title", "subtitle"}, (SuggestionsBuilder)b)).then(class_2170.method_9247((String)"text").then(class_2170.method_9244((String)"component", (ArgumentType)class_2178.method_9281((class_7157)buildContext)).executes(ctx -> CommandClaim.editClaimMessages((CommandContext<class_2168>)ctx, class_2178.method_9280((CommandContext)ctx, (String)"component")))))).then(class_2170.method_9247((String)"string").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.string()).executes(CommandClaim::editClaimMessages))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"group").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.group"))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.string()).executes(CommandClaim::addGroup)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::groupSuggestion).executes(CommandClaim::removeGroup)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"players").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.word()).suggests(CommandHelpers::groupSuggestion).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(CommandClaim::addPlayer)).then(class_2170.method_9247((String)"overwrite").executes(CommandClaim::forceAddPlayer)))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.word()).suggests(CommandHelpers::groupSuggestion).then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).suggests((context, build) -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            String group = StringArgumentType.getString((CommandContext)context, (String)"group");
            List<Object> list = new ArrayList();
            class_2168 src = (class_2168)context.getSource();
            ClaimStorage storage = ClaimStorage.get(src.method_9225());
            Claim claim = storage.getClaimAt(src.method_9207().method_24515());
            if (claim != null && claim.canInteract(src.method_9207(), BuiltinPermission.EDITPERMS, src.method_9207().method_24515())) {
                list = claim.playersFromGroup(player.method_5682(), group);
            }
            return class_2172.method_9265(list, (SuggestionsBuilder)build);
        }).executes(CommandClaim::removePlayer))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fakePlayer").executes(CommandClaim::toggleFakePlayer)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.fakeplayer"))).then(class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).executes(CommandClaim::addFakePlayer)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.fakeplayer"))).then(class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).suggests((context, build) -> {
            List<Object> list = new ArrayList();
            class_2168 src = (class_2168)context.getSource();
            ClaimStorage storage = ClaimStorage.get(src.method_9225());
            Claim claim = storage.getClaimAt(src.method_9207().method_24515());
            if (claim != null && claim.canInteract(src.method_9207(), BuiltinPermission.EDITPERMS, src.method_9207().method_24515())) {
                list = claim.getAllowedFakePlayerUUID();
            }
            return class_2172.method_9265(list, (SuggestionsBuilder)build);
        }).executes(CommandClaim::removeFakePlayer))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"teleport").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.teleport"))).then(class_2170.method_9247((String)"self").then(class_2170.method_9244((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<class_2168>)ctx, b, ((class_2168)ctx.getSource()).method_9207().method_5667())).executes(CommandClaim::teleport)))).then(class_2170.method_9247((String)"global").then(class_2170.method_9244((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<class_2168>)ctx, b, null)).executes(CommandClaim::teleportAdminClaims)))).then(class_2170.method_9247((String)"other").then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<class_2168>)ctx, b, CommandHelpers.singleProfile((CommandContext<class_2168>)ctx, "player").getId())).executes(src -> CommandClaim.teleport((CommandContext<class_2168>)src, CommandHelpers.singleProfile((CommandContext<class_2168>)src, "player").getId()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"permission").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.permission"))).then(class_2170.method_9247((String)"personal").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::personalGroupSuggestion).then(class_2170.method_9244((String)"permission", (ArgumentType)class_2232.method_9441()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<class_2168>)ctx, b, true)).then(class_2170.method_9244((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> class_2172.method_9253((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(CommandClaim::editPersonalPerm)))))).then(class_2170.method_9247((String)"global").then(class_2170.method_9244((String)"permission", (ArgumentType)class_2232.method_9441()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<class_2168>)ctx, b, false)).then(class_2170.method_9244((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> class_2172.method_9253((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(CommandClaim::editGlobalPerm))))).then(class_2170.method_9247((String)"group").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::groupSuggestion).then(class_2170.method_9244((String)"permission", (ArgumentType)class_2232.method_9441()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<class_2168>)ctx, b, true)).then(class_2170.method_9244((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> class_2172.method_9253((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(CommandClaim::editGroupPerm))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ignoreList").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.claim.ignore", false))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9247((String)CustomInteractListScreenHandler.Type.ITEM.commandKey).then(class_2170.method_9244((String)"entry", (ArgumentType)class_7066.method_41170((class_5321)class_7924.field_41197)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<class_2168>)src, CustomInteractListScreenHandler.Type.ITEM))))).then(class_2170.method_9247((String)CustomInteractListScreenHandler.Type.BLOCKBREAK.commandKey).then(class_2170.method_9244((String)"entry", (ArgumentType)class_7066.method_41170((class_5321)class_7924.field_41254)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<class_2168>)src, CustomInteractListScreenHandler.Type.BLOCKBREAK))))).then(class_2170.method_9247((String)CustomInteractListScreenHandler.Type.BLOCKUSE.commandKey).then(class_2170.method_9244((String)"entry", (ArgumentType)class_7066.method_41170((class_5321)class_7924.field_41254)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<class_2168>)src, CustomInteractListScreenHandler.Type.BLOCKUSE))))).then(class_2170.method_9247((String)CustomInteractListScreenHandler.Type.ENTITYATTACK.commandKey).then(class_2170.method_9244((String)"entry", (ArgumentType)class_7066.method_41170((class_5321)class_7924.field_41266)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<class_2168>)src, CustomInteractListScreenHandler.Type.ENTITYATTACK))))).then(class_2170.method_9247((String)CustomInteractListScreenHandler.Type.ENTITYUSE.commandKey).then(class_2170.method_9244((String)"entry", (ArgumentType)class_7066.method_41170((class_5321)class_7924.field_41266)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<class_2168>)src, CustomInteractListScreenHandler.Type.ENTITYUSE)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9247((String)CustomInteractListScreenHandler.Type.ITEM.commandKey).then(class_2170.method_9244((String)"entry", (ArgumentType)class_7066.method_41170((class_5321)class_7924.field_41197)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<class_2168>)src, b, CustomInteractListScreenHandler.Type.ITEM)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<class_2168>)src, CustomInteractListScreenHandler.Type.ITEM))))).then(class_2170.method_9247((String)CustomInteractListScreenHandler.Type.BLOCKBREAK.commandKey).then(class_2170.method_9244((String)"entry", (ArgumentType)class_7066.method_41170((class_5321)class_7924.field_41254)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<class_2168>)src, b, CustomInteractListScreenHandler.Type.BLOCKBREAK)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<class_2168>)src, CustomInteractListScreenHandler.Type.BLOCKBREAK))))).then(class_2170.method_9247((String)CustomInteractListScreenHandler.Type.BLOCKUSE.commandKey).then(class_2170.method_9244((String)"entry", (ArgumentType)class_7066.method_41170((class_5321)class_7924.field_41254)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<class_2168>)src, b, CustomInteractListScreenHandler.Type.BLOCKUSE)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<class_2168>)src, CustomInteractListScreenHandler.Type.BLOCKUSE))))).then(class_2170.method_9247((String)CustomInteractListScreenHandler.Type.ENTITYATTACK.commandKey).then(class_2170.method_9244((String)"entry", (ArgumentType)class_7066.method_41170((class_5321)class_7924.field_41266)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<class_2168>)src, b, CustomInteractListScreenHandler.Type.ENTITYATTACK)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<class_2168>)src, CustomInteractListScreenHandler.Type.ENTITYATTACK))))).then(class_2170.method_9247((String)CustomInteractListScreenHandler.Type.ENTITYUSE.commandKey).then(class_2170.method_9244((String)"entry", (ArgumentType)class_7066.method_41170((class_5321)class_7924.field_41266)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<class_2168>)src, b, CustomInteractListScreenHandler.Type.ENTITYUSE)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<class_2168>)src, CustomInteractListScreenHandler.Type.ENTITYUSE))))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"help").executes(ctx -> CommandHelp.helpMessage((CommandContext<class_2168>)ctx, 0, builder.getArguments()))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandHelp.helpMessage((CommandContext<class_2168>)ctx, builder.getArguments())))).then(class_2170.method_9247((String)"cmd").then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.word()).suggests((ctx, sb) -> class_2172.method_9265(CommandHelp.registeredCommands((CommandContext<class_2168>)ctx, builder.getArguments()), (SuggestionsBuilder)sb)).executes(CommandHelp::helpCmd))));
        builder.then(class_2170.method_9247((String)"?").executes(ctx -> CommandHelp.helpCmd((CommandContext<class_2168>)ctx, "help")));
        dispatcher.register(builder);
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        ConfigHandler.reloadConfigs(((class_2168)context.getSource()).method_9211());
        ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("configReload"), new class_124[0]), true);
        return 1;
    }

    private static int addClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        if (!ItemInteractEvents.canClaimWorld(player.method_51469(), player)) {
            return 0;
        }
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        class_2338 from = class_2262.method_9696(context, (String)"from");
        class_2338 to = class_2262.method_9696(context, (String)"to");
        storage.createClaim(from, to, player);
        return 1;
    }

    private static int addClaimAs(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2338 to;
        class_2338 from;
        String as = StringArgumentType.getString(context, (String)"player");
        class_2960 levelID = class_2232.method_9443(context, (String)"dimension");
        class_3218 level = ((class_2168)context.getSource()).method_9211().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)levelID));
        if (level == null) {
            ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("noSuchLevel"), levelID), new class_124[0]), true);
            return 0;
        }
        UUID uuid = null;
        if (!as.equals("+Admin") && (uuid = (UUID)((class_2168)context.getSource()).method_9211().method_3793().method_14515(as).map(GameProfile::getId).orElse(null)) == null) {
            ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("noSuchPlayer"), as), new class_124[0]), true);
            return 0;
        }
        ClaimStorage storage = ClaimStorage.get(level);
        Claim claim = storage.createAdminClaim(from = class_2262.method_9696(context, (String)"from"), to = class_2262.method_9696(context, (String)"to"), level);
        if (claim == null) {
            ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("claimCreationFailCommand"), new class_124[0]), true);
            return 0;
        }
        if (uuid != null) {
            storage.transferOwner(claim, uuid);
        }
        ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("claimCreateSuccess"), class_124.field_1065), false);
        return 1;
    }

    private static int addClaimAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlayerClaimData data = PlayerClaimData.get(player);
        int usable = data.getClaimBlocks() + data.getAdditionalClaims() - data.usedClaimBlocks();
        int size = (int)Math.floor(Math.sqrt(usable));
        return CommandClaim.addClaimRect(context, size, size);
    }

    private static int addClaimRect(CommandContext<class_2168> context, int x, int z) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        if (!ItemInteractEvents.canClaimWorld(player.method_51469(), player)) {
            return 0;
        }
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        boolean evenX = x % 2 == 0;
        boolean evenZ = z % 2 == 0;
        class_2338 from = player.method_24515().method_10069(evenX ? -((int)((double)(x - 1) * 0.5)) : -((int)((double)x * 0.5)), -5, evenZ ? -((int)((double)(z - 1) * 0.5)) : -((int)((double)z * 0.5)));
        class_2338 to = player.method_24515().method_10069((int)((double)x * 0.5), -5, (int)((double)z * 0.5));
        storage.createClaim(from, to, player);
        return 1;
    }

    private static int transferClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Collection profs = class_2191.method_9330(context, (String)"player");
        if (profs.size() != 1) {
            ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("onlyOnePlayer"), class_124.field_1061), false);
            return 0;
        }
        GameProfile prof = (GameProfile)profs.iterator().next();
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        Claim claim = storage.getClaimAt(player.method_24515());
        if (claim == null) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("noClaim"), class_124.field_1061), false);
            return 0;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        boolean enoughBlocks = true;
        if (!data.isAdminIgnoreClaim()) {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            class_3222 newOwner = server.method_3760().method_14602(prof.getId());
            IPlayerData newData = newOwner != null ? PlayerClaimData.get(newOwner) : new OfflinePlayerData(server, prof.getId());
            enoughBlocks = newData.canUseClaimBlocks(claim.getPlane());
        }
        if (!enoughBlocks) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("ownerTransferNoBlocks"), class_124.field_1061), false);
            if (PermissionNodeHandler.INSTANCE.perm((class_2168)context.getSource(), "flan.command.bypass.claim", true)) {
                player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("ownerTransferNoBlocksAdmin"), class_124.field_1061), false);
            }
            return 0;
        }
        if (!storage.transferOwner(claim, player, prof.getId())) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("ownerTransferFail"), class_124.field_1061), false);
            return 0;
        }
        player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("ownerTransferSuccess"), prof.getName()), class_124.field_1065), false);
        return 1;
    }

    private static int openMenu(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlayerClaimData data = PlayerClaimData.get(player);
        Claim claim = ClaimStorage.get(player.method_51469()).getClaimAt(player.method_24515());
        if (claim == null) {
            PermHelper.noClaimMessage(player);
            return 0;
        }
        if (data.getEditMode() == EnumEditMode.DEFAULT) {
            ClaimMenuScreenHandler.openClaimMenu(player, claim);
            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
        } else {
            Claim sub = claim.getSubClaim(player.method_24515());
            if (sub != null) {
                ClaimMenuScreenHandler.openClaimMenu(player, sub);
            } else {
                ClaimMenuScreenHandler.openClaimMenu(player, claim);
            }
        }
        return 1;
    }

    private static int trapped(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.setTrappedRescue()) {
            ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("trappedRescue"), class_124.field_1065), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("trappedFail"), class_124.field_1061), false);
        return 0;
    }

    private static int nameClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.getEditMode() == EnumEditMode.DEFAULT) {
            Claim claim = PermHelper.checkReturn(player, BuiltinPermission.EDITPERMS, PermHelper.genericNoPermMessage(player));
            if (claim == null) {
                return 0;
            }
            boolean nameUsed = ClaimStorage.get(player.method_51469()).allClaimsFromPlayer(claim.getOwner()).stream().map(Claim::getClaimName).anyMatch(name -> name.equals(StringArgumentType.getString((CommandContext)context, (String)"name")));
            if (!nameUsed) {
                String name2 = StringArgumentType.getString(context, (String)"name");
                claim.setClaimName(name2);
                player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("claimNameSet"), name2), class_124.field_1065), false);
            } else {
                player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("claimNameUsed"), class_124.field_1079), false);
            }
        } else {
            Claim claim = ClaimStorage.get(player.method_51469()).getClaimAt(player.method_24515());
            Claim sub = claim.getSubClaim(player.method_24515());
            if (sub != null && (claim.canInteract(player, BuiltinPermission.EDITPERMS, player.method_24515()) || sub.canInteract(player, BuiltinPermission.EDITPERMS, player.method_24515()))) {
                boolean nameUsed = claim.getAllSubclaims().stream().map(Claim::getClaimName).anyMatch(name -> name.equals(StringArgumentType.getString((CommandContext)context, (String)"name")));
                if (!nameUsed) {
                    String name3 = StringArgumentType.getString(context, (String)"name");
                    sub.setClaimName(name3);
                    player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("claimNameSet"), name3), class_124.field_1065), false);
                } else {
                    player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("claimNameUsedSub"), class_124.field_1079), false);
                }
            } else if (claim.canInteract(player, BuiltinPermission.EDITPERMS, player.method_24515())) {
                boolean nameUsed = ClaimStorage.get(player.method_51469()).allClaimsFromPlayer(claim.getOwner()).stream().map(Claim::getClaimName).anyMatch(name -> name.equals(StringArgumentType.getString((CommandContext)context, (String)"name")));
                if (!nameUsed) {
                    String name4 = StringArgumentType.getString(context, (String)"name");
                    claim.setClaimName(name4);
                    player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("claimNameSet"), name4), class_124.field_1065), false);
                } else {
                    player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("claimNameUsed"), class_124.field_1079), false);
                }
            } else {
                player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("noPermission"), class_124.field_1079), false);
            }
        }
        return 1;
    }

    private static int unlockDrops(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlayerClaimData data = PlayerClaimData.get(player);
        data.unlockDeathItems();
        ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("unlockDrops"), ConfigHandler.config.dropTicks), class_124.field_1065), false);
        return 1;
    }

    private static int unlockDropsPlayers(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection profs = class_2191.method_9330(context, (String)"players");
        ArrayList<String> success = new ArrayList<String>();
        for (GameProfile prof : profs) {
            class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(prof.getId());
            if (player == null) continue;
            PlayerClaimData data = PlayerClaimData.get(player);
            data.unlockDeathItems();
            success.add(prof.getName());
        }
        ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("unlockDropsMulti"), success), class_124.field_1065), false);
        return 1;
    }

    private static int openPersonalGroups(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PersonalGroupScreenHandler.openGroupMenu((class_1657)player);
        return 1;
    }

    private static int claimInfo(CommandContext<class_2168> context) throws CommandSyntaxException {
        return CommandClaim.claimInfo(context, CommandHelpers.parseEnum(Claim.InfoType.class, StringArgumentType.getString(context, (String)"type"), Claim.InfoType.ALL));
    }

    private static int claimInfo(CommandContext<class_2168> context, Claim.InfoType infoType) throws CommandSyntaxException {
        Claim sub;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Claim claim = ClaimStorage.get(player.method_51469()).getClaimAt(player.method_24515());
        PlayerClaimData data = PlayerClaimData.get(player);
        if (claim == null) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("noClaim"), class_124.field_1061), false);
            return 0;
        }
        if (data.getEditMode() == EnumEditMode.SUBCLAIM && (sub = claim.getSubClaim(player.method_24515())) != null) {
            List<class_2561> info = sub.infoString(player, infoType);
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("claimSubHeader"), class_124.field_1075), false);
            for (class_2561 text : info) {
                player.method_7353(text, false);
            }
            return 1;
        }
        List<class_2561> info = claim.infoString(player, infoType);
        for (class_2561 text : info) {
            player.method_7353(text, false);
        }
        return 1;
    }

    private static int deleteClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        Claim claim = storage.getClaimAt(player.method_24515());
        boolean check = PermHelper.check(player, player.method_24515(), claim, BuiltinPermission.EDITCLAIM, b -> {
            if (!b.isPresent()) {
                PermHelper.noClaimMessage(player);
            } else if (!((Boolean)b.get()).booleanValue()) {
                player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("deleteClaimError"), class_124.field_1079), false);
            }
        });
        if (!check) {
            return 0;
        }
        if (!storage.deleteClaim(claim, true, PlayerClaimData.get(player).getEditMode(), player.method_51469())) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("deleteSubClaimError"), class_124.field_1079), false);
        } else {
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("deleteClaim"), class_124.field_1061), false);
        }
        return 1;
    }

    private static int deleteAllClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.confirmedDeleteAll()) {
            for (class_3218 world : player.method_5682().method_3738()) {
                ClaimStorage storage = ClaimStorage.get(world);
                storage.allClaimsFromPlayer(player.method_5667()).forEach(claim -> storage.deleteClaim((Claim)claim, true, PlayerClaimData.get(player).getEditMode(), player.method_51469()));
            }
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("deleteAllClaim"), class_124.field_1065), false);
            data.setConfirmDeleteAll(false);
        } else {
            data.setConfirmDeleteAll(true);
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("deleteAllClaimConfirm"), class_124.field_1079), false);
        }
        return 1;
    }

    private static int deleteSubClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        Claim claim = storage.getClaimAt(player.method_24515());
        if (claim == null) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("noClaim"), class_124.field_1061), false);
            return 0;
        }
        Claim sub = claim.getSubClaim(player.method_24515());
        if (sub == null) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("noClaim"), class_124.field_1061), false);
            return 0;
        }
        boolean check = PermHelper.check(player, player.method_24515(), claim, BuiltinPermission.EDITCLAIM, b -> {
            if (!b.isPresent()) {
                PermHelper.noClaimMessage(player);
            } else if (!((Boolean)b.get()).booleanValue()) {
                player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("deleteClaimError"), class_124.field_1079), false);
            } else {
                player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("deleteSubClaim"), class_124.field_1079), false);
            }
        });
        if (!check) {
            return 0;
        }
        claim.deleteSubClaim(sub);
        return 1;
    }

    private static int deleteAllSubClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Claim claim = PermHelper.checkReturn(player, BuiltinPermission.EDITCLAIM, PermHelper.genericNoPermMessage(player));
        if (claim == null) {
            return 0;
        }
        List<Claim> subs = claim.getAllSubclaims();
        subs.forEach(claim::deleteSubClaim);
        player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("deleteSubClaimAll"), class_124.field_1079), false);
        return 1;
    }

    private static int listClaims(CommandContext<class_2168> context) throws CommandSyntaxException {
        return CommandClaim.listClaimsFromUUID(context, null);
    }

    private static int listClaims(CommandContext<class_2168> context, Collection<GameProfile> profs) throws CommandSyntaxException {
        if (profs.size() != 1) {
            ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("onlyOnePlayer"), class_124.field_1061), false);
            return 0;
        }
        GameProfile prof = profs.iterator().next();
        if (prof == null || prof.getId() == null) {
            return 0;
        }
        return CommandClaim.listClaimsFromUUID(context, prof.getId());
    }

    private static int listClaimsFromUUID(CommandContext<class_2168> context, UUID of) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3222 player = of == null ? ((class_2168)context.getSource()).method_9207() : server.method_3760().method_14602(of);
        HashMap<class_3218, Collection<Claim>> claims = new HashMap<class_3218, Collection<Claim>>();
        for (class_3218 class_32182 : server.method_3738()) {
            ClaimStorage storage = ClaimStorage.get(class_32182);
            claims.put(class_32182, storage.allClaimsFromPlayer(player != null ? player.method_5667() : of));
        }
        if (ConfigHandler.config.maxClaimBlocks != -1) {
            if (player != null) {
                data = PlayerClaimData.get(player);
                ((class_2168)context.getSource()).method_9226(() -> CommandClaim.lambda$listClaimsFromUUID$93((PlayerClaimData)data), false);
            } else {
                data = new OfflinePlayerData(server, of);
                ((class_2168)context.getSource()).method_9226(() -> CommandClaim.lambda$listClaimsFromUUID$94((OfflinePlayerData)data), false);
            }
        }
        ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("listClaims"), class_124.field_1065), false);
        for (Map.Entry entry : claims.entrySet()) {
            for (Claim claim : (Collection)entry.getValue()) {
                ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(((class_1937)entry.getKey()).method_27983().method_29177().toString() + " # " + claim.formattedClaim(), class_124.field_1054), false);
            }
        }
        return 1;
    }

    private static int switchClaimMode(CommandContext<class_2168> context) throws CommandSyntaxException {
        PlayerClaimData data;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        data.setEditMode((data = PlayerClaimData.get(player)).getEditMode() == EnumEditMode.DEFAULT ? EnumEditMode.SUBCLAIM : EnumEditMode.DEFAULT);
        player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("editMode"), new Object[]{data.getEditMode()}), class_124.field_1065), false);
        return 1;
    }

    private static int switchAdminMode(CommandContext<class_2168> context) throws CommandSyntaxException {
        PlayerClaimData data;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        data.setAdminIgnoreClaim(!(data = PlayerClaimData.get(player)).isAdminIgnoreClaim());
        player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("adminMode"), data.isAdminIgnoreClaim()), class_124.field_1065), false);
        return 1;
    }

    private static int adminDelete(CommandContext<class_2168> context) {
        class_2168 src = (class_2168)context.getSource();
        ClaimStorage storage = ClaimStorage.get(src.method_9225());
        Claim claim = storage.getClaimAt(class_2338.method_49638((class_2374)src.method_9222()));
        if (claim == null) {
            src.method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("noClaim"), class_124.field_1061), false);
            return 0;
        }
        storage.deleteClaim(claim, true, EnumEditMode.DEFAULT, src.method_9225());
        src.method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("deleteClaim"), class_124.field_1061), true);
        return 1;
    }

    private static int adminDeleteAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player;
        PlayerClaimData data;
        class_2168 src = (class_2168)context.getSource();
        class_1297 class_12972 = src.method_9228();
        if (class_12972 instanceof class_3222 && !(data = PlayerClaimData.get(player = (class_3222)class_12972)).confirmedDeleteAll()) {
            data.setConfirmDeleteAll(true);
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("deleteAllClaimConfirm"), class_124.field_1079), false);
            return 1;
        }
        ArrayList<String> players = new ArrayList<String>();
        for (GameProfile prof : class_2191.method_9330(context, (String)"players")) {
            for (class_3218 world : src.method_9225().method_8503().method_3738()) {
                ClaimStorage storage = ClaimStorage.get(world);
                storage.allClaimsFromPlayer(prof.getId()).forEach(claim -> storage.deleteClaim((Claim)claim, true, EnumEditMode.DEFAULT, world));
            }
            players.add(prof.getName());
        }
        src.method_9226(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("adminDeleteAll"), players), class_124.field_1065), true);
        return 1;
    }

    private static int toggleAdminClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        Claim claim = storage.getClaimAt(player.method_24515());
        if (claim == null) {
            ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("noClaim"), class_124.field_1061), false);
            return 0;
        }
        storage.toggleAdminClaim(player, claim, BoolArgumentType.getBool(context, (String)"toggle"));
        ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("setAdminClaim"), claim.isAdminClaim()), class_124.field_1065), true);
        return 1;
    }

    private static int listAdminClaims(CommandContext<class_2168> context) {
        class_2168 src = (class_2168)context.getSource();
        Collection<Claim> claims = ClaimStorage.get(src.method_9225()).getAdminClaims();
        src.method_9226(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("listAdminClaims"), src.method_9225().method_27983().method_29177()), class_124.field_1065), false);
        for (Claim claim : claims) {
            src.method_9226(() -> PermHelper.simpleColoredText(claim.formattedClaim(), class_124.field_1054), false);
        }
        return 1;
    }

    private static int readGriefPreventionData(CommandContext<class_2168> context) {
        class_2168 src = (class_2168)context.getSource();
        src.method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("readGriefpreventionData"), class_124.field_1065), true);
        if (ClaimStorage.readGriefPreventionData(src.method_9211(), src)) {
            src.method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("readGriefpreventionClaimDataSuccess"), class_124.field_1065), true);
        }
        if (PlayerClaimData.readGriefPreventionPlayerData(src.method_9211(), src)) {
            src.method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("readGriefpreventionPlayerDataSuccess"), class_124.field_1065), true);
        }
        return 1;
    }

    private static int giveClaimBlocks(CommandContext<class_2168> context) throws CommandSyntaxException {
        return CommandClaim.giveClaimBlocks(context, false);
    }

    private static int giveClaimBlocks(CommandContext<class_2168> context, boolean base) throws CommandSyntaxException {
        class_2168 src = (class_2168)context.getSource();
        ArrayList<String> players = new ArrayList<String>();
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (GameProfile prof : class_2191.method_9330(context, (String)"players")) {
            class_3222 player = src.method_9211().method_3760().method_14602(prof.getId());
            if (player != null) {
                PlayerClaimData data = PlayerClaimData.get(player);
                if (base) {
                    data.addClaimBlocksDirect(amount);
                } else {
                    data.setAdditionalClaims(data.getAdditionalClaims() + amount);
                }
            } else {
                PlayerClaimData.editForOfflinePlayer(src.method_9211(), prof.getId(), amount, base);
            }
            players.add(prof.getName());
        }
        src.method_9226(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get(base ? "giveClaimBlocks" : "giveClaimBlocksBonus"), players, amount), class_124.field_1065), true);
        return 1;
    }

    private static int addGroup(CommandContext<class_2168> context) throws CommandSyntaxException {
        return CommandClaim.modifyGroup(context, false);
    }

    private static int removeGroup(CommandContext<class_2168> context) throws CommandSyntaxException {
        return CommandClaim.modifyGroup(context, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int modifyGroup(CommandContext<class_2168> context, boolean remove) throws CommandSyntaxException {
        Claim sub;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String group = StringArgumentType.getString(context, (String)"group");
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        Claim claim = storage.getClaimAt(player.method_24515());
        if (claim == null) {
            PermHelper.noClaimMessage(player);
            return 0;
        }
        if (PlayerClaimData.get(player).getEditMode() == EnumEditMode.SUBCLAIM && (sub = claim.getSubClaim(player.method_24515())) != null) {
            claim = sub;
        }
        if (remove) {
            if (claim.removePermGroup(player, group)) {
                player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("groupRemove"), group), class_124.field_1065), false);
                return 1;
            }
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("noPermission"), class_124.field_1079), false);
            return 0;
        }
        if (claim.groups().contains(group)) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("groupExist"), group), class_124.field_1061), false);
            return 0;
        }
        if (claim.editPerms(player, group, BuiltinPermission.EDITPERMS, -1)) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("groupAdd"), group), class_124.field_1065), false);
            return 1;
        }
        player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("noPermission"), class_124.field_1079), false);
        return 0;
    }

    private static int forceAddPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        String group = StringArgumentType.getString(context, (String)"group");
        return CommandClaim.modifyPlayer(context, group, true);
    }

    private static int addPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        String group = StringArgumentType.getString(context, (String)"group");
        return CommandClaim.modifyPlayer(context, group, false);
    }

    private static int removePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return CommandClaim.modifyPlayer(context, null, false);
    }

    private static int modifyPlayer(CommandContext<class_2168> context, String group, boolean force) throws CommandSyntaxException {
        Claim sub;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        Claim claim = storage.getClaimAt(player.method_24515());
        if (claim == null) {
            PermHelper.noClaimMessage(player);
            return 0;
        }
        if (PlayerClaimData.get(player).getEditMode() == EnumEditMode.SUBCLAIM && (sub = claim.getSubClaim(player.method_24515())) != null) {
            claim = sub;
        }
        if (!claim.canInteract(player, BuiltinPermission.EDITPERMS, player.method_24515())) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("noPermission"), class_124.field_1079), false);
            return 0;
        }
        ArrayList<String> modified = new ArrayList<String>();
        for (GameProfile prof : class_2191.method_9330(context, (String)"players")) {
            if (!claim.setPlayerGroup(prof.getId(), group, force)) continue;
            modified.add(prof.getName());
        }
        if (!modified.isEmpty()) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("playerModify"), group, modified), class_124.field_1065), false);
        } else {
            player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("playerModifyNo"), group), class_124.field_1061), false);
        }
        return modified.size();
    }

    private static int toggleFakePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        PlayerClaimData data;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        data.setFakePlayerNotif(!(data = PlayerClaimData.get(player)).hasFakePlayerNotificationOn());
        player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("fakePlayerNotification"), data.hasFakePlayerNotificationOn()), class_124.field_1065), false);
        return 1;
    }

    private static int addFakePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return CommandClaim.modifyFakePlayer(context, false);
    }

    private static int removeFakePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return CommandClaim.modifyFakePlayer(context, true);
    }

    private static int modifyFakePlayer(CommandContext<class_2168> context, boolean remove) throws CommandSyntaxException {
        Claim sub;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        Claim claim = storage.getClaimAt(player.method_24515());
        if (claim == null) {
            PermHelper.noClaimMessage(player);
            return 0;
        }
        if (PlayerClaimData.get(player).getEditMode() == EnumEditMode.SUBCLAIM && (sub = claim.getSubClaim(player.method_24515())) != null) {
            claim = sub;
        }
        if (!claim.canInteract(player, BuiltinPermission.EDITPERMS, player.method_24515())) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("noPermission"), class_124.field_1079), false);
            return 0;
        }
        UUID uuid = class_5242.method_27645(context, (String)"uuid");
        if (claim.modifyFakePlayerUUID(uuid, remove)) {
            if (!remove) {
                player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("uuidFakeAdd"), uuid), class_124.field_1065), false);
            } else {
                player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("uuidFakeRemove"), uuid), class_124.field_1065), false);
            }
            return 1;
        }
        player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("uuidFakeModifyNo"), class_124.field_1061), false);
        return 0;
    }

    private static int editGlobalPerm(CommandContext<class_2168> context) throws CommandSyntaxException {
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        return CommandClaim.editPerms(context, null, mode);
    }

    private static int editGroupPerm(CommandContext<class_2168> context) throws CommandSyntaxException {
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        return CommandClaim.editPerms(context, StringArgumentType.getString(context, (String)"group"), mode);
    }

    private static int editPerms(CommandContext<class_2168> context, String group, int mode) throws CommandSyntaxException {
        String setPerm;
        Claim sub;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Claim claim = ClaimStorage.get(player.method_51469()).getClaimAt(player.method_24515());
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.getEditMode() == EnumEditMode.SUBCLAIM && (sub = claim.getSubClaim(player.method_24515())) != null) {
            claim = sub;
        }
        if (claim == null) {
            PermHelper.noClaimMessage(player);
            return 0;
        }
        if (PlayerClaimData.get(player).getEditMode() == EnumEditMode.SUBCLAIM && (sub = claim.getSubClaim(player.method_24515())) != null) {
            claim = sub;
        }
        if (!claim.canInteract(player, BuiltinPermission.EDITPERMS, player.method_24515())) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("noPermission"), class_124.field_1079), false);
            return 0;
        }
        class_2960 perm = class_2232.method_9443(context, (String)"permission");
        if (group != null && PermissionManager.INSTANCE.isGlobalPermission(perm)) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("nonGlobalOnly"), perm), class_124.field_1079), false);
            return 0;
        }
        if (PermissionManager.INSTANCE.get(perm) == null) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("noSuchPerm"), perm), class_124.field_1079), false);
            return 0;
        }
        String string = mode == 1 ? "true" : (setPerm = mode == 0 ? "false" : "default");
        if (group == null) {
            claim.editGlobalPerms(player, perm, mode);
            player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("editPerm"), perm, setPerm), class_124.field_1065), false);
        } else {
            claim.editPerms(player, group, perm, mode);
            player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("editPermGroup"), perm, group, setPerm), class_124.field_1065), false);
        }
        return 1;
    }

    private static int editPersonalPerm(CommandContext<class_2168> context) throws CommandSyntaxException {
        String setPerm;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String group = StringArgumentType.getString(context, (String)"group");
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        class_2960 perm = class_2232.method_9443(context, (String)"permission");
        if (PermissionManager.INSTANCE.isGlobalPermission(perm)) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("nonGlobalOnly"), perm), class_124.field_1079), false);
            return 0;
        }
        if (PermissionManager.INSTANCE.get(perm) == null) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("noSuchPerm"), perm), class_124.field_1079), false);
            return 0;
        }
        String string = mode == 1 ? "true" : (setPerm = mode == 0 ? "false" : "default");
        if (PlayerClaimData.get(player).editDefaultPerms(group, perm, mode)) {
            player.method_7353((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("editPersonalGroup"), group, perm, setPerm), class_124.field_1065), false);
        }
        return 1;
    }

    public static int setClaimHome(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Claim claim = PermHelper.checkReturn(player, BuiltinPermission.EDITCLAIM, PermHelper.genericNoPermMessage(player));
        if (claim == null) {
            return 0;
        }
        claim.setHomePos(player.method_24515());
        ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("setHome"), player.method_24515().method_10263(), player.method_24515().method_10264(), player.method_24515().method_10260()), class_124.field_1065), false);
        return 1;
    }

    private static int expandClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Claim claim = PermHelper.checkReturn(player, BuiltinPermission.EDITCLAIM, PermHelper.genericNoPermMessage(player));
        if (claim == null) {
            return 0;
        }
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        int amount = IntegerArgumentType.getInteger(context, (String)"distance");
        int[] dims = claim.getDimensions();
        int x = dims[0];
        int X = dims[1];
        int z = dims[2];
        int Z = dims[3];
        int y = dims[4];
        class_2350 facing = player.method_5735();
        class_3545 cornerPair = switch (facing) {
            case class_2350.field_11035 -> new class_3545((Object)new class_2338(X, y, Z), (Object)new class_2338(X, y, Z + amount));
            case class_2350.field_11034 -> new class_3545((Object)new class_2338(X, y, Z), (Object)new class_2338(X + amount, y, Z));
            case class_2350.field_11043 -> new class_3545((Object)new class_2338(x, y, z), (Object)new class_2338(x, y, z - amount));
            case class_2350.field_11039 -> new class_3545((Object)new class_2338(x, y, z), (Object)new class_2338(x - amount, y, z));
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
        };
        return storage.resizeClaim(claim, (class_2338)cornerPair.method_15442(), (class_2338)cornerPair.method_15441(), player) ? 1 : 0;
    }

    public static int teleport(CommandContext<class_2168> context) throws CommandSyntaxException {
        return CommandClaim.teleport(context, ((class_2168)context.getSource()).method_9207().method_5667());
    }

    public static int teleportAdminClaims(CommandContext<class_2168> context) throws CommandSyntaxException {
        return CommandClaim.teleport(context, null);
    }

    public static int teleport(CommandContext<class_2168> context, UUID owner) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String name = StringArgumentType.getString(context, (String)"claim");
        Optional<Claim> claims = ClaimStorage.get(player.method_51469()).allClaimsFromPlayer(owner).stream().filter(claim -> {
            if (claim.getClaimName().isEmpty()) {
                return claim.getClaimID().toString().equals(name);
            }
            return claim.getClaimName().equals(name);
        }).findFirst();
        if (claims.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("teleportNoClaim"), class_124.field_1061), false);
            return 0;
        }
        return claims.map(claim -> {
            class_2338 pos = claim.getHomePos();
            if (claim.canInteract(player, BuiltinPermission.TELEPORT, pos, false)) {
                PlayerClaimData data = PlayerClaimData.get(player);
                if (data.setTeleportTo(pos)) {
                    ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("teleportHome"), class_124.field_1065), false);
                    return 1;
                }
                ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("teleportHomeFail"), class_124.field_1061), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("noPermissionSimple"), class_124.field_1079), false);
            }
            return 0;
        }).orElse(0);
    }

    public static int editClaimMessages(CommandContext<class_2168> context) throws CommandSyntaxException {
        return CommandClaim.editClaimMessages(context, (class_2561)class_2561.method_43470((String)StringArgumentType.getString(context, (String)"message")));
    }

    public static int editClaimMessages(CommandContext<class_2168> context, class_2561 text) throws CommandSyntaxException {
        String feedback;
        Claim claim;
        if (text instanceof class_5250) {
            class_2583 style = text.method_10866();
            if (style.method_10967()) {
                style = style.method_27706(class_124.field_1068);
            }
            if (!style.method_10966()) {
                style = style.method_10978(Boolean.valueOf(false));
            }
            ((class_5250)text).method_10862(style);
        }
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlayerClaimData data = PlayerClaimData.get(player);
        Claim rootClaim = PermHelper.checkReturn(player, BuiltinPermission.CLAIMMESSAGE, PermHelper.genericNoPermMessage(player));
        if (rootClaim == null) {
            return 0;
        }
        Claim claim2 = claim = data.getEditMode() == EnumEditMode.SUBCLAIM ? rootClaim.getSubClaim(player.method_24515()) : rootClaim;
        if (claim == null) {
            return 0;
        }
        boolean sub = StringArgumentType.getString(context, (String)"title").equals("subtitle");
        boolean enter = StringArgumentType.getString(context, (String)"type").equals("enter");
        if (enter) {
            if (sub) {
                claim.setEnterTitle(claim.enterTitle, text);
                feedback = ConfigHandler.langManager.get("setEnterSubMessage");
            } else {
                claim.setEnterTitle(text, claim.enterSubtitle);
                feedback = ConfigHandler.langManager.get("setEnterMessage");
            }
        } else if (sub) {
            claim.setLeaveTitle(claim.leaveTitle, text);
            feedback = ConfigHandler.langManager.get("setLeaveSubMessage");
        } else {
            claim.setLeaveTitle(text, claim.leaveSubtitle);
            feedback = ConfigHandler.langManager.get("setLeaveMessage");
        }
        class_5250 cmdFeed = class_2561.method_43469((String)feedback, (Object[])new Object[]{text}).method_27692(class_124.field_1065);
        ((class_2168)context.getSource()).method_9226(() -> cmdFeed, false);
        return 1;
    }

    public static int addClaimListEntries(CommandContext<class_2168> context, CustomInteractListScreenHandler.Type type) throws CommandSyntaxException {
        Claim claim;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlayerClaimData data = PlayerClaimData.get(player);
        Claim rootClaim = PermHelper.checkReturn(player, BuiltinPermission.CLAIMMESSAGE, PermHelper.genericNoPermMessage(player));
        if (rootClaim == null) {
            return 0;
        }
        Claim claim2 = claim = data.getEditMode() == EnumEditMode.SUBCLAIM ? rootClaim.getSubClaim(player.method_24515()) : rootClaim;
        if (claim == null) {
            return 0;
        }
        String result = switch (type) {
            default -> throw new MatchException(null, null);
            case CustomInteractListScreenHandler.Type.ITEM -> CommandClaim.addClaimListEntry(context, class_7923.field_41178, claim.allowedItems);
            case CustomInteractListScreenHandler.Type.BLOCKBREAK -> CommandClaim.addClaimListEntry(context, class_7923.field_41175, claim.allowedBreakBlocks);
            case CustomInteractListScreenHandler.Type.BLOCKUSE -> CommandClaim.addClaimListEntry(context, class_7923.field_41175, claim.allowedUseBlocks);
            case CustomInteractListScreenHandler.Type.ENTITYATTACK -> CommandClaim.addClaimListEntry(context, class_7923.field_41177, claim.allowedEntityAttack);
            case CustomInteractListScreenHandler.Type.ENTITYUSE -> CommandClaim.addClaimListEntry(context, class_7923.field_41177, claim.allowedEntityUse);
        };
        class_5250 cmdFeed = class_2561.method_43469((String)ConfigHandler.langManager.get("addIgnoreEntry"), (Object[])new Object[]{result, type.commandKey}).method_27692(class_124.field_1065);
        ((class_2168)context.getSource()).method_9226(() -> cmdFeed, false);
        return 1;
    }

    public static int removeClaimListEntries(CommandContext<class_2168> context, CustomInteractListScreenHandler.Type type) throws CommandSyntaxException {
        Claim claim;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlayerClaimData data = PlayerClaimData.get(player);
        Claim rootClaim = PermHelper.checkReturn(player, BuiltinPermission.CLAIMMESSAGE, PermHelper.genericNoPermMessage(player));
        if (rootClaim == null) {
            return 0;
        }
        Claim claim2 = claim = data.getEditMode() == EnumEditMode.SUBCLAIM ? rootClaim.getSubClaim(player.method_24515()) : rootClaim;
        if (claim == null) {
            return 0;
        }
        String value = ((class_7066.class_7068)context.getArgument("entry", class_7066.class_7068.class)).method_41176();
        switch (type) {
            case ITEM: {
                claim.allowedItems.removeAllowedItem(value);
                break;
            }
            case BLOCKBREAK: {
                claim.allowedBreakBlocks.removeAllowedItem(value);
                break;
            }
            case BLOCKUSE: {
                claim.allowedUseBlocks.removeAllowedItem(value);
                break;
            }
            case ENTITYATTACK: {
                claim.allowedEntityAttack.removeAllowedItem(value);
                break;
            }
            case ENTITYUSE: {
                claim.allowedEntityUse.removeAllowedItem(value);
            }
        }
        class_5250 cmdFeed = class_2561.method_43469((String)ConfigHandler.langManager.get("removeIgnoreEntry"), (Object[])new Object[]{value, type.commandKey}).method_27692(class_124.field_1065);
        ((class_2168)context.getSource()).method_9226(() -> cmdFeed, false);
        return 1;
    }

    private static int sellClaimBlocks(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean b = ConfigHandler.config.buySellHandler.sell(((class_2168)context.getSource()).method_9207(), Math.max(0, IntegerArgumentType.getInteger(context, (String)"amount")), m -> ((class_2168)context.getSource()).method_9226(() -> m, false));
        return b ? 1 : 0;
    }

    private static int buyClaimBlocks(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean b = ConfigHandler.config.buySellHandler.buy(((class_2168)context.getSource()).method_9207(), Math.max(0, IntegerArgumentType.getInteger(context, (String)"amount")), m -> ((class_2168)context.getSource()).method_9226(() -> m, false));
        return b ? 1 : 0;
    }

    private static <T> String addClaimListEntry(CommandContext<class_2168> context, class_2378<T> registry, AllowedRegistryList<T> list) throws CommandSyntaxException {
        class_7066.class_7068 value = CommandHelpers.getRegistryType(context, "entry", registry.method_30517());
        value.method_41173().ifRight(tag -> list.addAllowedItem(Either.right((Object)tag))).ifLeft(id -> {
            Object entry = registry.method_29107(id);
            if (entry != class_1802.field_8162) {
                list.addAllowedItem(Either.left((Object)entry));
            }
        });
        return value.method_41176();
    }

    private static /* synthetic */ class_2561 lambda$listClaimsFromUUID$94(OfflinePlayerData data) {
        return PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("claimBlocksFormat"), data.claimBlocks, data.getAdditionalClaims(), data.usedClaimBlocks(), data.remainingClaimBlocks()), class_124.field_1065);
    }

    private static /* synthetic */ class_2561 lambda$listClaimsFromUUID$93(PlayerClaimData data) {
        return PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("claimBlocksFormat"), data.getClaimBlocks(), data.getAdditionalClaims(), data.usedClaimBlocks(), data.remainingClaimBlocks()), class_124.field_1065);
    }
}

