/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class CommandHelp {
    public static int helpMessage(CommandContext<class_2168> context, Collection<CommandNode<class_2168>> nodes) {
        int page = IntegerArgumentType.getInteger(context, (String)"page");
        return CommandHelp.helpMessage(context, page, nodes);
    }

    public static int helpMessage(CommandContext<class_2168> context, int pageC, Collection<CommandNode<class_2168>> nodes) {
        List<String> subCommands = CommandHelp.registeredCommands(context, nodes);
        subCommands.remove("?");
        int max = subCommands.size() / 8;
        int page = Math.min(pageC, max);
        ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("helpHeader"), page), class_124.field_1065), false);
        for (int i = 8 * page; i < 8 * (page + 1); ++i) {
            if (i >= subCommands.size()) continue;
            String sub = subCommands.get(i);
            class_5250 cmdText = PermHelper.simpleColoredText("- " + sub, class_124.field_1080);
            ((class_2168)context.getSource()).method_9226(() -> cmdText.method_27696(cmdText.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, "/flan help cmd " + sub))), false);
        }
        class_5250 txt = PermHelper.simpleColoredText((page > 0 ? "  " : "") + " ", class_124.field_1077);
        if (page > 0) {
            class_5250 pageTextBack = PermHelper.simpleColoredText("<<", class_124.field_1077);
            pageTextBack.method_27696(pageTextBack.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, "/flan help " + (page - 1))));
            txt = pageTextBack.method_10852((class_2561)txt);
        }
        if (page < max) {
            class_5250 pageTextNext = PermHelper.simpleColoredText(">>", new class_124[0]);
            pageTextNext.method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/flan help " + (page + 1))));
            txt = txt.method_10852((class_2561)pageTextNext);
        }
        class_5250 pageText = txt;
        ((class_2168)context.getSource()).method_9226(() -> pageText, false);
        return 1;
    }

    public static int helpCmd(CommandContext<class_2168> context) {
        String command = StringArgumentType.getString(context, (String)"command");
        return CommandHelp.helpCmd(context, command);
    }

    public static int helpCmd(CommandContext<class_2168> context, String command) {
        String[] cmdHelp = ConfigHandler.langManager.getArray("command." + command);
        ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("helpCmdHeader"), class_124.field_1077), false);
        for (int i = 0; i < cmdHelp.length; ++i) {
            String cmp;
            if (i == 0) {
                cmp = cmdHelp[i];
                ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("helpCmdSyntax"), cmp), class_124.field_1065), false);
                ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText("", new class_124[0]), false);
                continue;
            }
            cmp = cmdHelp[i];
            ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(cmp, class_124.field_1065), false);
        }
        if (command.equals("help")) {
            ((class_2168)context.getSource()).method_9226(() -> PermHelper.simpleColoredText(ConfigHandler.langManager.get("wiki"), class_124.field_1065), false);
            class_5250 wiki = PermHelper.simpleColoredText("https://github.com/Flemmli97/Flan/wiki", class_124.field_1060);
            wiki.method_10862(wiki.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/Flemmli97/Flan/wiki")));
            ((class_2168)context.getSource()).method_9226(() -> wiki, false);
        }
        return 1;
    }

    public static List<String> registeredCommands(CommandContext<class_2168> context, Collection<CommandNode<class_2168>> nodes) {
        return nodes.stream().filter(node -> node.canUse((Object)((class_2168)context.getSource()))).map(CommandNode::getName).collect(Collectors.toList());
    }
}

