/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.CustomInteractListScreenHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7066;

public class CommandHelpers {
    private static final Pattern ALLOWED = Pattern.compile("[a-zA-Z0-9_+.-]+");

    public static CompletableFuture<Suggestions> claimSuggestions(CommandContext<class_2168> context, SuggestionsBuilder build, UUID owner) {
        return class_2172.method_9265((Iterable)ClaimStorage.get(((class_2168)context.getSource()).method_9225()).allClaimsFromPlayer(owner).stream().map(claim -> claim.getClaimName().isEmpty() ? claim.getClaimID().toString() : claim.getClaimName()).collect(Collectors.toList()), (SuggestionsBuilder)build);
    }

    public static GameProfile singleProfile(CommandContext<class_2168> context, String arg) throws CommandSyntaxException {
        Collection profs = class_2191.method_9330(context, (String)arg);
        if (profs.size() != 1) {
            throw new SimpleCommandExceptionType(() -> ConfigHandler.langManager.get("onlyOnePlayer")).create();
        }
        return (GameProfile)profs.stream().findFirst().get();
    }

    public static CompletableFuture<Suggestions> permSuggestions(CommandContext<class_2168> context, SuggestionsBuilder build, boolean group) {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        Claim claim = ClaimStorage.get(world).getClaimAt(class_2338.method_49638((class_2374)((class_2168)context.getSource()).method_9222()));
        boolean admin = claim != null && claim.isAdminClaim();
        ArrayList<String> allowedPerms = new ArrayList<String>();
        for (ClaimPermission perm : PermissionManager.INSTANCE.getAll()) {
            if (!admin && ConfigHandler.config.globallyDefined(world, perm.getId()) || group && perm.global) continue;
            allowedPerms.add(perm.getId().toString());
        }
        return class_2172.method_9265(allowedPerms, (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> groupSuggestion(CommandContext<class_2168> context, SuggestionsBuilder build) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        List<Object> list = new ArrayList();
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        Claim claim = storage.getClaimAt(player.method_24515());
        if (claim != null && claim.canInteract(player, BuiltinPermission.EDITPERMS, player.method_24515())) {
            list = claim.groups();
        }
        for (int i = 0; i < list.size(); ++i) {
            if (ALLOWED.matcher((CharSequence)list.get(i)).matches()) continue;
            list.set(i, "\"" + (String)list.get(i) + "\"");
        }
        return class_2172.method_9265(list, (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> personalGroupSuggestion(CommandContext<class_2168> context, SuggestionsBuilder build) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        ArrayList<String> list = new ArrayList<String>(PlayerClaimData.get(player).playerDefaultGroups().keySet());
        list.sort(null);
        for (int i = 0; i < list.size(); ++i) {
            if (ALLOWED.matcher((CharSequence)list.get(i)).matches()) continue;
            list.set(i, "\"" + (String)list.get(i) + "\"");
        }
        return class_2172.method_9265(list, (SuggestionsBuilder)build);
    }

    public static <T extends Enum<T>> T parseEnum(Class<T> clss, String name, T fallback) {
        try {
            return Enum.valueOf(clss, name);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
    }

    public static <T extends Enum<T>> CompletableFuture<Suggestions> enumSuggestion(Class<T> clss, SuggestionsBuilder build) {
        return class_2172.method_9264(Stream.of((Enum[])clss.getEnumConstants()).map(Object::toString), (SuggestionsBuilder)build);
    }

    public static <T> class_7066.class_7068<T> getRegistryType(CommandContext<class_2168> context, String name, class_5321<class_2378<T>> registryKey) throws CommandSyntaxException {
        class_7066.class_7068 result = (class_7066.class_7068)context.getArgument(name, class_7066.class_7068.class);
        Optional optional = result.method_41175(registryKey);
        return (class_7066.class_7068)optional.orElseThrow(() -> new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"No such entry %1$s", (Object[])new Object[]{object})).create((Object)result));
    }

    public static CompletableFuture<Suggestions> claimEntryListSuggestion(CommandContext<class_2168> context, SuggestionsBuilder build, CustomInteractListScreenHandler.Type type) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        List<Object> list = new ArrayList();
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        Claim claim = storage.getClaimAt(player.method_24515());
        if (claim != null && claim.canInteract(player, BuiltinPermission.EDITPERMS, player.method_24515())) {
            switch (type) {
                case ITEM: {
                    list = claim.allowedItems.asString();
                    break;
                }
                case BLOCKBREAK: {
                    list = claim.allowedBreakBlocks.asString();
                    break;
                }
                case BLOCKUSE: {
                    list = claim.allowedUseBlocks.asString();
                    break;
                }
                case ENTITYATTACK: {
                    list = claim.allowedEntityAttack.asString();
                    break;
                }
                case ENTITYUSE: {
                    list = claim.allowedEntityUse.asString();
                }
            }
        }
        return class_2172.method_9265(list, (SuggestionsBuilder)build);
    }
}

