/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.integration.currency.CommandCurrency;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class BuySellHandler {
    private static int[] xpCalc;
    private Type buyType = Type.MONEY;
    private Type sellType = Type.MONEY;
    private float buyAmount = -1.0f;
    private final List<BuyIngredient> buyIngredients = new ArrayList<BuyIngredient>();
    private float sellAmount = -1.0f;
    private class_1856 sellIngredient = class_1856.field_9017;

    public boolean buy(class_3222 player, int blocks, Consumer<class_2561> message) {
        if (this.buyAmount == -1.0f && this.buyType != Type.ITEM) {
            message.accept((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("buyDisabled"), class_124.field_1079));
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (ConfigHandler.config.maxBuyBlocks >= 0 && data.getAdditionalClaims() + blocks > ConfigHandler.config.maxBuyBlocks) {
            message.accept((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("buyLimit"), class_124.field_1079));
            return false;
        }
        switch (this.buyType.ordinal()) {
            case 0: {
                return CommandCurrency.INSTANCE.buyClaimBlocks(player, blocks, this.buyAmount, message);
            }
            case 1: {
                if (this.buyIngredients.isEmpty()) {
                    message.accept((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("buyDisabled"), class_124.field_1079));
                    return false;
                }
                float payed = 0.0f;
                ArrayList<Pair> matching = new ArrayList<Pair>();
                block5: for (BuyIngredient ing : this.buyIngredients) {
                    for (class_1799 stack : player.method_31548().field_7547) {
                        if (!ing.ingredient().method_8093(stack) || stack.method_7963() && stack.method_7919() != 0 || !this.isJustRenamedItem(stack)) continue;
                        float toPay = (float)blocks - payed;
                        int count = Math.min(stack.method_7947(), class_3532.method_15386((float)(toPay / ing.amount())));
                        float amount = (float)count * ing.amount();
                        payed += amount;
                        matching.add(Pair.of((Object)stack, (Object)count));
                        if (!(payed >= (float)blocks)) continue;
                        break block5;
                    }
                }
                if (payed < (float)blocks) {
                    message.accept((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("buyFailItem"), class_124.field_1079));
                    return false;
                }
                int count = 0;
                for (Pair stack : matching) {
                    ((class_1799)stack.getFirst()).method_7934(((Integer)stack.getSecond()).intValue());
                    count += ((Integer)stack.getSecond()).intValue();
                }
                data.setAdditionalClaims(data.getAdditionalClaims() + blocks);
                message.accept((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("buySuccessItem"), blocks, count), new class_124[0]));
                return true;
            }
            case 2: {
                int deduct = class_3532.method_15386((float)((float)blocks * this.buyAmount));
                if ((float)deduct < (float)BuySellHandler.totalXpPointsForLevel(player.field_7520) + player.field_7510 * (float)BuySellHandler.xpForLevel(player.field_7520 + 1)) {
                    player.method_7255(-deduct);
                    data.setAdditionalClaims(data.getAdditionalClaims() + blocks);
                    message.accept((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("buySuccessXP"), blocks, deduct), new class_124[0]));
                    return true;
                }
                message.accept((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("buyFailXP"), class_124.field_1079));
                return false;
            }
        }
        return false;
    }

    public boolean sell(class_3222 player, int blocks, Consumer<class_2561> message) {
        if (this.sellAmount == -1.0f) {
            message.accept((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("sellDisabled"), class_124.field_1079));
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.getAdditionalClaims() - Math.max(0, data.usedClaimBlocks() - data.getClaimBlocks()) < blocks) {
            message.accept((class_2561)PermHelper.simpleColoredText(ConfigHandler.langManager.get("sellFail"), class_124.field_1079));
            return false;
        }
        switch (this.sellType.ordinal()) {
            case 0: {
                return CommandCurrency.INSTANCE.sellClaimBlocks(player, blocks, this.sellAmount, message);
            }
            case 1: {
                class_1799[] stacks = this.sellIngredient.method_8105();
                if (this.sellIngredient.method_8103()) {
                    return false;
                }
                int amount = class_3532.method_15375((float)((float)blocks * this.sellAmount));
                class_1799 stack = stacks[0];
                while (amount > 0) {
                    class_1542 itemEntity;
                    boolean bl;
                    class_1799 toGive = stack.method_7972();
                    if (amount > 64) {
                        toGive.method_7939(64);
                        amount -= 64;
                    } else {
                        toGive.method_7939(amount);
                        amount = 0;
                    }
                    if ((bl = player.method_31548().method_7394(toGive)) && toGive.method_7960() || (itemEntity = player.method_7328(toGive, false)) == null) continue;
                    itemEntity.method_6975();
                    itemEntity.method_48349(player.method_5667());
                }
                data.setAdditionalClaims(data.getAdditionalClaims() - blocks);
                message.accept((class_2561)class_2561.method_43469((String)ConfigHandler.langManager.get("sellSuccessItem"), (Object[])new Object[]{blocks, amount, class_2561.method_43471((String)stack.method_7922()).method_27692(class_124.field_1075)}));
                return true;
            }
            case 2: {
                int amount = class_3532.method_15375((float)((float)blocks * this.buyAmount));
                player.method_7255(amount);
                data.setAdditionalClaims(data.getAdditionalClaims() - blocks);
                message.accept((class_2561)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("sellSuccessXP"), blocks, amount), new class_124[0]));
                return false;
            }
        }
        return false;
    }

    private boolean isJustRenamedItem(class_1799 stack) {
        return stack.method_57380().method_57846().stream().noneMatch(e -> e.getKey() != class_9334.field_49631);
    }

    private static int totalXpPointsForLevel(int level) {
        if (xpCalc == null || level > xpCalc.length) {
            xpCalc = new int[level + 50];
            BuySellHandler.xpCalc[0] = 0;
            for (int i = 1; i < xpCalc.length; ++i) {
                BuySellHandler.xpCalc[i] = BuySellHandler.xpForLevel(i) + xpCalc[i - 1];
            }
        }
        return xpCalc[level];
    }

    private static int xpForLevel(int level) {
        if (--level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("buyType", this.buyType.toString());
        obj.addProperty("buyValue", (Number)Float.valueOf(this.buyAmount));
        JsonArray buyArr = new JsonArray();
        this.buyIngredients.forEach(b -> {
            JsonObject buyObj = new JsonObject();
            buyObj.addProperty("amount", (Number)Float.valueOf(b.amount()));
            buyObj.add("ingredient", (JsonElement)class_1856.field_46095.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)b.ingredient()).getOrThrow());
            buyArr.add((JsonElement)buyObj);
        });
        obj.add("buyIngredients", (JsonElement)buyArr);
        obj.addProperty("sellType", this.sellType.toString());
        obj.addProperty("sellValue", (Number)Float.valueOf(this.sellAmount));
        obj.add("sellIngredient", (JsonElement)class_1856.field_46095.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.sellIngredient).getOrThrow());
        return obj;
    }

    public void fromJson(JsonObject object) {
        this.buyType = Type.valueOf(ConfigHandler.fromJson(object, "buyType", this.buyType.toString()));
        this.buyAmount = object.has("buyValue") ? object.get("buyValue").getAsFloat() : this.buyAmount;
        this.buyIngredients.clear();
        JsonArray obj = ConfigHandler.arryFromJson(object, "buyIngredients");
        obj.forEach(k -> {
            JsonObject o = k.getAsJsonObject();
            try {
                class_1856 ingredient;
                class_1856 class_18562 = ingredient = o.has("ingredient") ? (class_1856)class_1856.field_46095.parse((DynamicOps)JsonOps.INSTANCE, (Object)o.get("ingredient")).getOrThrow() : class_1856.field_9017;
                if (ingredient != class_1856.field_9017) {
                    float amount = o.get("amount").getAsFloat();
                    this.buyIngredients.add(new BuyIngredient(amount, ingredient));
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        });
        this.buyIngredients.sort(BuyIngredient::compareTo);
        this.sellType = Type.valueOf(ConfigHandler.fromJson(object, "sellType", this.sellType.toString()));
        this.sellAmount = object.has("sellValue") ? object.get("sellValue").getAsFloat() : this.sellAmount;
        try {
            class_1856 legacy = object.has("ingredient") ? (class_1856)class_1856.field_46095.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("ingredient")).getOrThrow() : class_1856.field_9017;
            this.sellIngredient = object.has("sellIngredient") ? (class_1856)class_1856.field_46095.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("sellIngredient")).getOrThrow() : legacy;
        }
        catch (JsonParseException e) {
            this.sellIngredient = class_1856.field_9017;
        }
    }

    static enum Type {
        MONEY,
        ITEM,
        XP;

    }

    record BuyIngredient(float amount, class_1856 ingredient) implements Comparable<BuyIngredient>
    {
        @Override
        public int compareTo(@NotNull BuyIngredient buyIngredient) {
            return Float.compare(buyIngredient.amount, this.amount);
        }
    }
}

