/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.config;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.config.BuySellHandler;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.config.ConfigUpdater;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class Config {
    private File config;
    public int startingBlocks = 500;
    public int maxClaimBlocks = 5000;
    public int ticksForNextBlock = 600;
    public int minClaimsize = 100;
    public int defaultClaimDepth = 10;
    public int maxClaims = -1;
    public String defaultClaimName = "";
    public String defaultEnterMessage = "";
    public String defaultLeaveMessage = "";
    public boolean spawnProtection;
    public int nextClaimCooldown;
    public String[] blacklistedWorlds = new String[0];
    public boolean worldWhitelist;
    public class_1792 claimingItem = class_1802.field_8303;
    public class_2487 claimingNBT = new class_2487();
    public class_1792 inspectionItem = class_1802.field_8600;
    public class_2487 inspectionNBT = new class_2487();
    public int claimDisplayTime = 600;
    public boolean particleDisplay = false;
    public boolean claimDisplayActionBar = false;
    public int permissionLevel = 2;
    public boolean autoClaimStructures;
    public BuySellHandler buySellHandler = new BuySellHandler();
    public int maxBuyBlocks = -1;
    public boolean lenientBlockEntityCheck;
    public List<String> breakBlockBlacklist = Lists.newArrayList((Object[])new String[]{"universal_graves:grave", "yigd:grave"});
    public List<String> interactBlockBlacklist = Lists.newArrayList((Object[])new String[]{"universal_graves:grave", "yigd:grave", "waystones", "universal_shops:trade_block"});
    public List<String> breakBETagBlacklist = Lists.newArrayList();
    public List<String> interactBETagBlacklist = Lists.newArrayList((Object[])new String[]{"IsDeathChest", "gunpowder.owner", "shop-activated"});
    public List<String> ignoredEntityTypes = Lists.newArrayList((Object[])new String[]{"corpse:corpse"});
    public List<String> entityTagIgnore = Lists.newArrayList((Object[])new String[]{"graves.marker"});
    public List<String> itemPermission = Lists.newArrayList((Object[])new String[]{"@c:wrenches-flan:interact_block", "appliedenergistics2:nether_quartz_wrench-flan:interact_block", "appliedenergistics2:certus_quartz_wrench-flan:interact_block"});
    public List<String> blockPermission = Lists.newArrayList();
    public List<String> entityPermission = Lists.newArrayList((Object[])new String[]{"taterzens:npc-flan:trading"});
    public List<String> leftClickBlockPermission = Lists.newArrayList((Object[])new String[]{"@storagedrawers:drawers-flan:open_container", "mekanism:basic_bin-flan:open_container", "mekanism:advanced_bin-flan:open_container", "mekanism:ultimate_bin-flan:open_container", "mekanism:creative_bin-flan:open_container"});
    public int dropTicks = 6000;
    public int inactivityTime = 30;
    public int inactivityBlocksMax = 2000;
    public boolean deletePlayerFile = false;
    public int bannedDeletionTime = 30;
    public int offlineProtectActivation = -1;
    public boolean log;
    public String lang = "en_us";
    public int configVersion = 4;
    public int preConfigVersion;
    public boolean ftbChunksCheck = true;
    public boolean gomlReservedCheck = true;
    public boolean mineColoniesCheck = true;
    public Map<String, Map<class_2960, Boolean>> defaultGroups = Config.createHashMap(map -> {
        map.put("Co-Owner", Config.createLinkedHashMap(perms -> PermissionManager.INSTANCE.getAll().forEach(p -> perms.put(p.getId(), true))));
        map.put("Visitor", Config.createLinkedHashMap(perms -> {
            perms.put(BuiltinPermission.BED, true);
            perms.put(BuiltinPermission.DOOR, true);
            perms.put(BuiltinPermission.FENCEGATE, true);
            perms.put(BuiltinPermission.TRAPDOOR, true);
            perms.put(BuiltinPermission.BUTTONLEVER, true);
            perms.put(BuiltinPermission.PRESSUREPLATE, true);
            perms.put(BuiltinPermission.ENDERCHEST, true);
            perms.put(BuiltinPermission.ENCHANTMENTTABLE, true);
            perms.put(BuiltinPermission.ITEMFRAMEROTATE, true);
            perms.put(BuiltinPermission.PORTAL, true);
            perms.put(BuiltinPermission.TRADING, true);
        }));
    });
    protected final Map<String, Map<class_2960, GlobalType>> globalDefaultPerms = Config.createHashMap(map -> map.put("*", Config.createHashMap(perms -> {
        perms.put(BuiltinPermission.FLIGHT, GlobalType.ALLTRUE);
        perms.put(BuiltinPermission.MOBSPAWN, GlobalType.ALLFALSE);
        perms.put(BuiltinPermission.TELEPORT, GlobalType.ALLFALSE);
        perms.put(BuiltinPermission.NOHUNGER, GlobalType.ALLFALSE);
        perms.put(BuiltinPermission.EDITPOTIONS, GlobalType.ALLFALSE);
        perms.put(BuiltinPermission.LOCKITEMS, GlobalType.ALLTRUE);
    })));

    public Config(MinecraftServer server) {
        File configDir = CrossPlatformStuff.INSTANCE.configPath().resolve("flan").toFile();
        try {
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            this.config = new File(configDir, "flan_config.json");
            if (!this.config.exists()) {
                this.config.createNewFile();
                this.save();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            FileReader reader = new FileReader(this.config);
            JsonObject obj = (JsonObject)ConfigHandler.GSON.fromJson((Reader)reader, JsonObject.class);
            reader.close();
            this.preConfigVersion = ConfigHandler.fromJson(obj, "configVersion", 0);
            this.lang = ConfigHandler.fromJson(obj, "lang", this.lang);
            this.startingBlocks = ConfigHandler.fromJson(obj, "startingBlocks", this.startingBlocks);
            this.maxClaimBlocks = ConfigHandler.fromJson(obj, "maxClaimBlocks", this.maxClaimBlocks);
            this.ticksForNextBlock = ConfigHandler.fromJson(obj, "ticksForNextBlock", this.ticksForNextBlock);
            this.minClaimsize = ConfigHandler.fromJson(obj, "minClaimsize", this.minClaimsize);
            this.defaultClaimDepth = ConfigHandler.fromJson(obj, "defaultClaimDepth", this.defaultClaimDepth);
            this.maxClaims = ConfigHandler.fromJson(obj, "maxClaims", this.maxClaims);
            this.defaultClaimName = ConfigHandler.fromJson(obj, "defaultClaimName", this.defaultClaimName);
            this.defaultEnterMessage = ConfigHandler.fromJson(obj, "defaultEnterMessage", this.defaultEnterMessage);
            this.defaultLeaveMessage = ConfigHandler.fromJson(obj, "defaultLeaveMessage", this.defaultLeaveMessage);
            this.spawnProtection = ConfigHandler.fromJson(obj, "noSpawnClaim", this.spawnProtection);
            this.nextClaimCooldown = ConfigHandler.fromJson(obj, "claimingCooldown", this.nextClaimCooldown);
            JsonArray arr = ConfigHandler.arryFromJson(obj, "blacklistedWorlds");
            this.blacklistedWorlds = new String[arr.size()];
            for (int i = 0; i < arr.size(); ++i) {
                this.blacklistedWorlds[i] = arr.get(i).getAsString();
            }
            this.worldWhitelist = ConfigHandler.fromJson(obj, "worldWhitelist", this.worldWhitelist);
            if (obj.has("claimingItem")) {
                this.claimingItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)obj.get("claimingItem").getAsString()));
            }
            this.claimingNBT = (class_2487)class_2487.field_25128.parse((DynamicOps)JsonOps.INSTANCE, (Object)class_3518.method_15281((JsonObject)obj, (String)"claimingNBT", (JsonObject)new JsonObject())).getOrThrow();
            if (obj.has("inspectionItem")) {
                this.inspectionItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)obj.get("inspectionItem").getAsString()));
            }
            this.inspectionNBT = (class_2487)class_2487.field_25128.parse((DynamicOps)JsonOps.INSTANCE, (Object)class_3518.method_15281((JsonObject)obj, (String)"inspectionNBT", (JsonObject)new JsonObject())).getOrThrow();
            this.claimDisplayTime = ConfigHandler.fromJson(obj, "claimDisplayTime", this.claimDisplayTime);
            this.particleDisplay = ConfigHandler.fromJson(obj, "particleDisplay", this.particleDisplay);
            this.claimDisplayActionBar = ConfigHandler.fromJson(obj, "claimDisplayActionBar", this.claimDisplayActionBar);
            this.permissionLevel = ConfigHandler.fromJson(obj, "permissionLevel", this.permissionLevel);
            this.autoClaimStructures = ConfigHandler.fromJson(obj, "autoClaimStructures", this.autoClaimStructures);
            this.ftbChunksCheck = ConfigHandler.fromJson(obj, "ftbChunksCheck", this.ftbChunksCheck);
            this.gomlReservedCheck = ConfigHandler.fromJson(obj, "gomlReservedCheck", this.gomlReservedCheck);
            this.mineColoniesCheck = ConfigHandler.fromJson(obj, "mineColoniesCheck", this.mineColoniesCheck);
            this.buySellHandler.fromJson(ConfigHandler.fromJson(obj, "buySellHandler"));
            this.maxBuyBlocks = ConfigHandler.fromJson(obj, "maxBuyBlocks", this.maxBuyBlocks);
            this.lenientBlockEntityCheck = ConfigHandler.fromJson(obj, "lenientBlockEntityCheck", this.lenientBlockEntityCheck);
            this.breakBlockBlacklist.clear();
            ConfigHandler.arryFromJson(obj, "breakBlockBlacklist").forEach(e -> this.breakBlockBlacklist.add(e.getAsString()));
            this.interactBlockBlacklist.clear();
            ConfigHandler.arryFromJson(obj, "interactBlockBlacklist").forEach(e -> this.interactBlockBlacklist.add(e.getAsString()));
            this.breakBETagBlacklist.clear();
            ConfigHandler.arryFromJson(obj, "breakBlockEntityTagBlacklist").forEach(e -> this.breakBETagBlacklist.add(e.getAsString()));
            this.interactBETagBlacklist.clear();
            ConfigHandler.arryFromJson(obj, "interactBlockEntityTagBlacklist").forEach(e -> this.interactBETagBlacklist.add(e.getAsString()));
            this.ignoredEntityTypes.clear();
            ConfigHandler.arryFromJson(obj, "ignoredEntities").forEach(e -> this.ignoredEntityTypes.add(e.getAsString()));
            this.entityTagIgnore.clear();
            ConfigHandler.arryFromJson(obj, "entityTagIgnore").forEach(e -> this.entityTagIgnore.add(e.getAsString()));
            this.itemPermission.clear();
            ConfigHandler.arryFromJson(obj, "customItemPermission").forEach(e -> this.itemPermission.add(e.getAsString()));
            this.blockPermission.clear();
            ConfigHandler.arryFromJson(obj, "customBlockPermission").forEach(e -> this.blockPermission.add(e.getAsString()));
            this.entityPermission.clear();
            ConfigHandler.arryFromJson(obj, "customEntityPermission").forEach(e -> this.entityPermission.add(e.getAsString()));
            this.leftClickBlockPermission.clear();
            ConfigHandler.arryFromJson(obj, "leftClickBlockPermission").forEach(e -> this.leftClickBlockPermission.add(e.getAsString()));
            this.dropTicks = ConfigHandler.fromJson(obj, "dropTicks", this.dropTicks);
            this.inactivityTime = ConfigHandler.fromJson(obj, "inactivityTimeDays", this.inactivityTime);
            this.inactivityBlocksMax = ConfigHandler.fromJson(obj, "inactivityBlocksMax", this.inactivityBlocksMax);
            this.deletePlayerFile = ConfigHandler.fromJson(obj, "deletePlayerFile", this.deletePlayerFile);
            this.bannedDeletionTime = ConfigHandler.fromJson(obj, "bannedDeletionTime", this.bannedDeletionTime);
            this.offlineProtectActivation = ConfigHandler.fromJson(obj, "offlineProtectActivation", this.offlineProtectActivation);
            this.log = ConfigHandler.fromJson(obj, "enableLogs", this.log);
            this.defaultGroups.clear();
            JsonObject defP = ConfigHandler.fromJson(obj, "defaultGroups");
            defP.entrySet().forEach(e -> {
                HashMap perms = new HashMap();
                if (((JsonElement)e.getValue()).isJsonObject()) {
                    ((JsonElement)e.getValue()).getAsJsonObject().entrySet().forEach(jperm -> {
                        class_2960 id = BuiltinPermission.tryLegacy((String)jperm.getKey());
                        ClaimPermission perm = PermissionManager.INSTANCE.get(id);
                        if (perm == null) {
                            Flan.error("Default groups: No such permission for {}", jperm.getKey());
                        } else {
                            perms.put(id, ((JsonElement)jperm.getValue()).getAsBoolean());
                        }
                    });
                }
                this.defaultGroups.put((String)e.getKey(), perms);
            });
            this.globalDefaultPerms.clear();
            JsonObject glob = ConfigHandler.fromJson(obj, "globalDefaultPerms");
            glob.entrySet().forEach(e -> {
                HashMap perms = new HashMap();
                if (((JsonElement)e.getValue()).isJsonObject()) {
                    ((JsonElement)e.getValue()).getAsJsonObject().entrySet().forEach(jperm -> {
                        class_2960 id = BuiltinPermission.tryLegacy((String)jperm.getKey());
                        ClaimPermission perm = PermissionManager.INSTANCE.get(id);
                        if (perm == null) {
                            Flan.error("Global Perms: No such permission for {}", jperm.getKey());
                        } else if (((JsonElement)jperm.getValue()).isJsonPrimitive() && ((JsonElement)jperm.getValue()).getAsJsonPrimitive().isBoolean()) {
                            perms.put(id, ((JsonElement)jperm.getValue()).getAsBoolean() ? GlobalType.ALLTRUE : GlobalType.ALLFALSE);
                        } else {
                            perms.put(id, GlobalType.valueOf(((JsonElement)jperm.getValue()).getAsString()));
                        }
                    });
                }
                this.globalDefaultPerms.put((String)e.getKey(), perms);
            });
            ConfigUpdater.updateConfig(this.preConfigVersion, obj);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.save();
    }

    private void save() {
        JsonObject obj = new JsonObject();
        obj.addProperty("__comment", "For help with the config refer to https://github.com/Flemmli97/Flan/wiki/Config");
        obj.addProperty("configVersion", (Number)this.configVersion);
        obj.addProperty("lang", this.lang);
        obj.addProperty("startingBlocks", (Number)this.startingBlocks);
        obj.addProperty("maxClaimBlocks", (Number)this.maxClaimBlocks);
        obj.addProperty("ticksForNextBlock", (Number)this.ticksForNextBlock);
        obj.addProperty("minClaimsize", (Number)this.minClaimsize);
        obj.addProperty("defaultClaimDepth", (Number)this.defaultClaimDepth);
        obj.addProperty("maxClaims", (Number)this.maxClaims);
        obj.addProperty("defaultClaimName", this.defaultClaimName);
        obj.addProperty("defaultEnterMessage", this.defaultEnterMessage);
        obj.addProperty("defaultLeaveMessage", this.defaultLeaveMessage);
        obj.addProperty("noSpawnClaim", Boolean.valueOf(this.spawnProtection));
        obj.addProperty("claimingCooldown", (Number)this.nextClaimCooldown);
        JsonArray arr = new JsonArray();
        for (String blacklistedWorld : this.blacklistedWorlds) {
            arr.add(blacklistedWorld);
        }
        obj.add("blacklistedWorlds", (JsonElement)arr);
        obj.addProperty("worldWhitelist", Boolean.valueOf(this.worldWhitelist));
        obj.addProperty("claimingItem", class_7923.field_41178.method_10221((Object)this.claimingItem).toString());
        obj.add("claimingNBT", (JsonElement)class_2487.field_25128.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.claimingNBT).getOrThrow());
        obj.addProperty("inspectionItem", class_7923.field_41178.method_10221((Object)this.inspectionItem).toString());
        obj.add("inspectionNBT", (JsonElement)class_2487.field_25128.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.inspectionNBT).getOrThrow());
        obj.addProperty("claimDisplayTime", (Number)this.claimDisplayTime);
        obj.addProperty("particleDisplay", Boolean.valueOf(this.particleDisplay));
        obj.addProperty("claimDisplayActionBar", Boolean.valueOf(this.claimDisplayActionBar));
        obj.addProperty("permissionLevel", (Number)this.permissionLevel);
        obj.addProperty("autoClaimStructures", Boolean.valueOf(this.autoClaimStructures));
        obj.addProperty("ftbChunksCheck", Boolean.valueOf(this.ftbChunksCheck));
        obj.addProperty("gomlReservedCheck", Boolean.valueOf(this.gomlReservedCheck));
        obj.addProperty("mineColoniesCheck", Boolean.valueOf(this.mineColoniesCheck));
        obj.add("buySellHandler", (JsonElement)this.buySellHandler.toJson());
        obj.addProperty("maxBuyBlocks", (Number)this.maxBuyBlocks);
        obj.addProperty("lenientBlockEntityCheck", Boolean.valueOf(this.lenientBlockEntityCheck));
        JsonArray blocksBreak = new JsonArray();
        this.breakBlockBlacklist.forEach(arg_0 -> ((JsonArray)blocksBreak).add(arg_0));
        obj.add("breakBlockBlacklist", (JsonElement)blocksBreak);
        JsonArray blocksInteract = new JsonArray();
        this.interactBlockBlacklist.forEach(arg_0 -> ((JsonArray)blocksInteract).add(arg_0));
        obj.add("interactBlockBlacklist", (JsonElement)blocksInteract);
        JsonArray blocksEntities = new JsonArray();
        this.breakBETagBlacklist.forEach(arg_0 -> ((JsonArray)blocksEntities).add(arg_0));
        obj.add("breakBlockEntityTagBlacklist", (JsonElement)blocksEntities);
        JsonArray blocksEntitiesInteract = new JsonArray();
        this.interactBETagBlacklist.forEach(arg_0 -> ((JsonArray)blocksEntitiesInteract).add(arg_0));
        obj.add("interactBlockEntityTagBlacklist", (JsonElement)blocksEntitiesInteract);
        JsonArray entities = new JsonArray();
        this.ignoredEntityTypes.forEach(arg_0 -> ((JsonArray)entities).add(arg_0));
        obj.add("ignoredEntities", (JsonElement)entities);
        JsonArray entitiesTags = new JsonArray();
        this.entityTagIgnore.forEach(arg_0 -> ((JsonArray)entitiesTags).add(arg_0));
        obj.add("entityTagIgnore", (JsonElement)entitiesTags);
        JsonArray itemPerms = new JsonArray();
        this.itemPermission.forEach(arg_0 -> ((JsonArray)itemPerms).add(arg_0));
        obj.add("customItemPermission", (JsonElement)itemPerms);
        JsonArray blockPerms = new JsonArray();
        this.blockPermission.forEach(arg_0 -> ((JsonArray)blockPerms).add(arg_0));
        obj.add("customBlockPermission", (JsonElement)blockPerms);
        JsonArray entityPerms = new JsonArray();
        this.entityPermission.forEach(arg_0 -> ((JsonArray)entityPerms).add(arg_0));
        obj.add("customEntityPermission", (JsonElement)entityPerms);
        JsonArray leftIgnore = new JsonArray();
        this.leftClickBlockPermission.forEach(arg_0 -> ((JsonArray)leftIgnore).add(arg_0));
        obj.add("leftClickBlockPermission", (JsonElement)leftIgnore);
        obj.addProperty("dropTicks", (Number)this.dropTicks);
        obj.addProperty("inactivityTimeDays", (Number)this.inactivityTime);
        obj.addProperty("inactivityBlocksMax", (Number)this.inactivityBlocksMax);
        obj.addProperty("deletePlayerFile", Boolean.valueOf(this.deletePlayerFile));
        obj.addProperty("bannedDeletionTime", (Number)this.bannedDeletionTime);
        obj.addProperty("offlineProtectActivation", (Number)this.offlineProtectActivation);
        obj.addProperty("enableLogs", Boolean.valueOf(this.log));
        JsonObject defPerm = new JsonObject();
        this.defaultGroups.forEach((key, value) -> {
            JsonObject perm = new JsonObject();
            value.forEach((key1, value1) -> perm.addProperty(key1.toString(), value1));
            defPerm.add(key, (JsonElement)perm);
        });
        obj.add("defaultGroups", (JsonElement)defPerm);
        JsonObject global = new JsonObject();
        this.globalDefaultPerms.forEach((key, value) -> {
            JsonObject perm = new JsonObject();
            value.forEach((key1, value1) -> perm.addProperty(key1.toString(), value1.toString()));
            global.add(key, (JsonElement)perm);
        });
        obj.add("globalDefaultPerms", (JsonElement)global);
        try {
            FileWriter writer = new FileWriter(this.config);
            ConfigHandler.GSON.toJson((JsonElement)obj, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean globallyDefined(class_3218 world, class_2960 perm) {
        return !this.getGlobal(world, perm).canModify();
    }

    public GlobalType getGlobal(class_3218 world, class_2960 perm) {
        Map<class_2960, GlobalType> permMap;
        Map<class_2960, GlobalType> allMap = ConfigHandler.config.globalDefaultPerms.get("*");
        if (allMap != null) {
            world.method_8503().method_3738().forEach(w -> {
                Map wMap = ConfigHandler.config.globalDefaultPerms.getOrDefault(w.method_27983().method_29177().toString(), new HashMap());
                allMap.forEach((key, value) -> {
                    if (!wMap.containsKey(key)) {
                        wMap.put(key, value);
                    }
                });
                ConfigHandler.config.globalDefaultPerms.put(w.method_27983().method_29177().toString(), wMap);
            });
            ConfigHandler.config.globalDefaultPerms.remove("*");
        }
        return (permMap = ConfigHandler.config.globalDefaultPerms.get(world.method_27983().method_29177().toString())) == null ? GlobalType.NONE : permMap.getOrDefault(perm, GlobalType.NONE);
    }

    public Stream<Map.Entry<class_2960, GlobalType>> getGloballyDefinedVals(class_3218 world) {
        Map<class_2960, GlobalType> permMap;
        Map<class_2960, GlobalType> allMap = ConfigHandler.config.globalDefaultPerms.get("*");
        if (allMap != null) {
            world.method_8503().method_3738().forEach(w -> {
                Map wMap = ConfigHandler.config.globalDefaultPerms.getOrDefault(w.method_27983().method_29177().toString(), new HashMap());
                allMap.forEach((key, value) -> {
                    if (!wMap.containsKey(key)) {
                        wMap.put(key, value);
                    }
                });
                ConfigHandler.config.globalDefaultPerms.put(w.method_27983().method_29177().toString(), wMap);
            });
            ConfigHandler.config.globalDefaultPerms.remove("*");
        }
        return (permMap = ConfigHandler.config.globalDefaultPerms.get(world.method_27983().method_29177().toString())) == null ? Stream.empty() : permMap.entrySet().stream().filter(e -> ((GlobalType)((Object)((Object)e.getValue()))).canModify());
    }

    public static <V, K> Map<V, K> createHashMap(Consumer<Map<V, K>> cons) {
        HashMap map = new HashMap();
        cons.accept(map);
        return map;
    }

    public static <V, K> Map<V, K> createLinkedHashMap(Consumer<Map<V, K>> cons) {
        LinkedHashMap map = new LinkedHashMap();
        cons.accept(map);
        return map;
    }

    public static enum GlobalType {
        ALLTRUE,
        ALLFALSE,
        TRUE,
        FALSE,
        NONE;


        public boolean getValue() {
            return this == ALLTRUE || this == TRUE;
        }

        public boolean canModify() {
            return this.ordinal() > 1;
        }
    }
}

