/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.flemmli97.flan.api.permission.ObjectToPermissionMap;
import io.github.flemmli97.flan.config.Config;
import io.github.flemmli97.flan.config.LangManager;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2874;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class ConfigHandler {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static Config config;
    public static LangManager langManager;
    private static final Map<class_5321<class_1937>, Path> CLAIM_SAVE_PATH;
    private static Path playerSavePath;

    public static void serverLoad(MinecraftServer server) {
        config = new Config(server);
        langManager = new LangManager();
        ConfigHandler.reloadConfigs(server);
    }

    public static void reloadConfigs(MinecraftServer server) {
        config.load();
        langManager.reload(ConfigHandler.config.lang);
        ObjectToPermissionMap.reload(server);
    }

    public static Path getClaimSavePath(MinecraftServer server, class_5321<class_1937> reg) {
        return CLAIM_SAVE_PATH.computeIfAbsent(reg, r -> class_2874.method_12488((class_5321)r, (Path)server.method_27050(class_5218.field_24188)).resolve("data").resolve("claims"));
    }

    public static Path getPlayerSavePath(MinecraftServer server) {
        if (playerSavePath == null) {
            playerSavePath = server.method_27050(class_5218.field_24182).resolve("claimData");
        }
        return playerSavePath;
    }

    public static boolean isClaimingTool(class_1799 stack) {
        return stack.method_7909() == ConfigHandler.config.claimingItem && ConfigHandler.partialyMatchNBT(ConfigHandler.config.claimingNBT, stack);
    }

    public static boolean isInspectionTool(class_1799 stack) {
        return stack.method_7909() == ConfigHandler.config.inspectionItem && ConfigHandler.partialyMatchNBT(ConfigHandler.config.inspectionNBT, stack);
    }

    private static boolean partialyMatchNBT(class_2487 config, class_1799 stack) {
        if (config == null) {
            return true;
        }
        class_2487 second = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (second.method_33133()) {
            return config.method_33133();
        }
        return config.method_10541().stream().allMatch(key -> Objects.equals(config.method_10580(key), second.method_10580(key)));
    }

    public static int fromJson(JsonObject obj, String key, int fallback) {
        try {
            return obj.get(key).getAsInt();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return fallback;
        }
    }

    public static boolean fromJson(JsonObject obj, String key, boolean fallback) {
        try {
            return obj.get(key).getAsBoolean();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return fallback;
        }
    }

    public static String fromJson(JsonObject obj, String key, String fallback) {
        try {
            return obj.get(key).getAsString();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return fallback;
        }
    }

    public static JsonObject fromJson(JsonObject obj, String key) {
        try {
            return obj.get(key).getAsJsonObject();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return new JsonObject();
        }
    }

    public static JsonArray arryFromJson(JsonObject obj, String key) {
        try {
            return obj.get(key).getAsJsonArray();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return new JsonArray();
        }
    }

    static {
        CLAIM_SAVE_PATH = new HashMap<class_5321<class_1937>, Path>();
    }
}

