/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.GroupPlayerScreenHandler;
import io.github.flemmli97.flan.gui.PermissionScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_6880;
import net.minecraft.class_9334;

public class GroupScreenHandler
extends ServerOnlyScreenHandler<Claim> {
    private final Claim claim;
    private boolean removeMode;

    private GroupScreenHandler(int syncId, class_1661 playerInventory, Claim claim) {
        super(syncId, playerInventory, 6, claim);
        this.claim = claim;
    }

    public static void openGroupMenu(class_1657 player, final Claim claim) {
        class_3908 fac = new class_3908(){

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new GroupScreenHandler(syncId, inv, claim);
            }

            public class_2561 method_5476() {
                return PermHelper.simpleColoredText(ConfigHandler.langManager.get("screenGroups"), new class_124[0]);
            }
        };
        player.method_17355(fac);
    }

    @Override
    protected void fillInventoryWith(class_1657 player, SeparateInv inv, Claim claim) {
        for (int i = 0; i < 54; ++i) {
            class_1799 stack;
            if (i == 0) {
                stack = new class_1799((class_1935)class_1802.field_8626);
                stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenBack"), class_124.field_1079));
                inv.updateStack(i, stack);
                continue;
            }
            if (i == 3) {
                stack = new class_1799((class_1935)class_1802.field_8782);
                stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenAdd"), class_124.field_1077));
                inv.updateStack(i, stack);
                continue;
            }
            if (i == 4) {
                stack = new class_1799((class_1935)class_1802.field_8793);
                stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenRemoveMode"), this.removeMode ? ConfigHandler.langManager.get("screenTrue") : ConfigHandler.langManager.get("screenFalse")), class_124.field_1079));
                inv.updateStack(i, stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                inv.updateStack(i, ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1;
            List<String> groups = claim.groups();
            if (id >= groups.size()) continue;
            class_1799 group = new class_1799((class_1935)class_1802.field_8407);
            group.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenGroupName"), groups.get(id)), class_124.field_1058));
            inv.updateStack(i, group);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(class_3222 player, int index, class_1735 slot, int clickType) {
        if (index == 0) {
            player.method_7346();
            player.method_5682().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, this.claim));
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.method_7346();
            player.method_5682().execute(() -> StringResultScreenHandler.createNewStringResult((class_1657)player, s -> {
                this.claim.editPerms(player, (String)s, BuiltinPermission.EDITPERMS, -1);
                player.method_7346();
                player.method_5682().execute(() -> GroupScreenHandler.openGroupMenu((class_1657)player, this.claim));
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_14559, 1.0f, 1.0f);
            }, () -> {
                player.method_7346();
                player.method_5682().execute(() -> GroupScreenHandler.openGroupMenu((class_1657)player, this.claim));
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_15008, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            class_1799 stack = new class_1799((class_1935)class_1802.field_8793);
            stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenRemoveMode"), this.removeMode ? ConfigHandler.langManager.get("screenTrue") : ConfigHandler.langManager.get("screenFalse")), class_124.field_1079));
            slot.method_7673(stack);
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        class_1799 stack = slot.method_7677();
        if (!stack.method_7960()) {
            String name = stack.method_7964().getString();
            if (this.removeMode) {
                this.claim.removePermGroup(player, name);
                slot.method_7673(class_1799.field_8037);
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_14911, 1.0f, 1.0f);
            } else {
                if (clickType == 1) {
                    player.method_7346();
                    player.method_5682().execute(() -> PermissionScreenHandler.openClaimMenu((class_1657)player, this.claim, name));
                } else {
                    player.method_7346();
                    player.method_5682().execute(() -> GroupPlayerScreenHandler.openPlayerGroupMenu((class_1657)player, this.claim, name));
                }
                ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            }
        }
        return false;
    }
}

