/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import com.google.common.collect.Lists;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class PotionEditScreenHandler
extends ServerOnlyScreenHandler<Claim> {
    private final Claim claim;
    private boolean removeMode;

    protected PotionEditScreenHandler(int syncId, class_1661 playerInventory, Claim claim) {
        super(syncId, playerInventory, 6, claim);
        this.claim = claim;
    }

    public static void openPotionMenu(class_1657 player, final Claim claim) {
        class_3908 fac = new class_3908(){

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new PotionEditScreenHandler(syncId, inv, claim);
            }

            public class_2561 method_5476() {
                return PermHelper.simpleColoredText(ConfigHandler.langManager.get("screenPotions"), new class_124[0]);
            }
        };
        player.method_17355(fac);
    }

    @Override
    protected void fillInventoryWith(class_1657 player, SeparateInv inv, Claim claim) {
        Map<class_6880<class_1291>, Integer> potions = claim.getPotions();
        ArrayList key = Lists.newArrayList(potions.keySet());
        key.sort(Comparator.comparing(class_6880::method_55840));
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                class_1799 close = new class_1799((class_1935)class_1802.field_8626);
                close.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenBack"), class_124.field_1079));
                inv.updateStack(i, close);
                continue;
            }
            if (i == 3) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8782);
                stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenAdd"), class_124.field_1077));
                inv.updateStack(i, stack);
                continue;
            }
            if (i == 4) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8793);
                stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenRemoveMode"), this.removeMode ? ConfigHandler.langManager.get("screenTrue") : ConfigHandler.langManager.get("screenFalse")), class_124.field_1079));
                inv.updateStack(i, stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                inv.updateStack(i, ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1;
            if (id >= potions.size()) continue;
            class_6880 effect = (class_6880)key.get(id);
            class_1799 effectStack = new class_1799((class_1935)class_1802.field_8574);
            class_5250 txt = class_2561.method_43471((String)((class_1291)effect.comp_349()).method_5567());
            Set<class_1293> inst = Collections.singleton(new class_1293(effect, 0, potions.get(effect).intValue()));
            effectStack.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.of(class_1844.method_8055(inst)), List.of()));
            class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)effectStack, tag -> tag.method_10582("FlanEffect", effect.method_55840()));
            txt.method_10852((class_2561)class_2561.method_43470((String)("-" + String.valueOf(potions.get(effect)))));
            class_5250 comp = class_2561.method_43469((String)ConfigHandler.langManager.get("screenPotionText"), (Object[])new Object[]{txt}).method_10862(txt.method_10866().method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1058));
            effectStack.method_57379(class_9334.field_49631, (Object)comp);
            inv.updateStack(i, effectStack);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(class_3222 player, int index, class_1735 slot, int clickType) {
        if (index == 0) {
            player.method_7346();
            player.method_5682().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, this.claim));
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.method_7346();
            player.method_5682().execute(() -> StringResultScreenHandler.createNewStringResult((class_1657)player, s -> {
                String[] potion = s.split(";");
                int amp = 1;
                Optional holder = class_7923.field_41174.method_55841(class_2960.method_60654((String)potion[0]));
                if (holder.map(effect -> effect == class_1294.field_5926 && !potion[0].equals("minecraft:luck")).orElse(true).booleanValue()) {
                    ServerScreenHelper.playSongToPlayer(player, class_3417.field_15008, 1.0f, 1.0f);
                    return;
                }
                if (potion.length > 1) {
                    try {
                        amp = Integer.parseInt(potion[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.claim.addPotion((class_6880<class_1291>)((class_6880)holder.get()), amp);
                player.method_7346();
                player.method_5682().execute(() -> PotionEditScreenHandler.openPotionMenu((class_1657)player, this.claim));
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_14559, 1.0f, 1.0f);
            }, () -> {
                player.method_7346();
                player.method_5682().execute(() -> PotionEditScreenHandler.openPotionMenu((class_1657)player, this.claim));
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_15008, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            class_1799 stack = new class_1799((class_1935)class_1802.field_8793);
            stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenRemoveMode"), this.removeMode ? ConfigHandler.langManager.get("screenTrue") : ConfigHandler.langManager.get("screenFalse")), class_124.field_1079));
            slot.method_7673(stack);
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        class_1799 stack = slot.method_7677();
        if (!stack.method_7960() && this.removeMode) {
            String effect = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10558("FlanEffect");
            if (!effect.isEmpty()) {
                class_7923.field_41174.method_55841(class_2960.method_60654((String)effect)).ifPresent(this.claim::removePotion);
            }
            slot.method_7673(class_1799.field_8037);
            ServerScreenHelper.playSongToPlayer(player, class_3417.field_14911, 1.0f, 1.0f);
        }
        return false;
    }
}

