/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.platform.integration.webmap;

import com.mojang.authlib.GameProfile;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.platform.integration.webmap.WebmapCalls;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;

public class DynmapIntegration {
    private static MarkerSet markerSet;
    private static final String markerID = "flan.claims";
    private static final String markerLabel = "Claims";

    public static void reg() {
        DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

            public void apiEnabled(DynmapCommonAPI dynmapCommonAPI) {
                MarkerAPI markerAPI = dynmapCommonAPI.getMarkerAPI();
                markerSet = markerAPI.createMarkerSet(DynmapIntegration.markerID, DynmapIntegration.markerLabel, dynmapCommonAPI.getMarkerAPI().getMarkerIcons(), false);
                WebmapCalls.dynmapLoaded = true;
            }
        });
    }

    static void addClaimMarker(Claim claim) {
        if (markerSet == null) {
            return;
        }
        int[] dim = claim.getDimensions();
        AreaMarker marker = markerSet.createAreaMarker(claim.getClaimID().toString(), DynmapIntegration.claimLabel(claim), true, DynmapIntegration.getWorldName((class_1937)claim.getLevel()), new double[]{dim[0], dim[1]}, new double[]{dim[2], dim[3]}, false);
        marker.setLineStyle(3, 0.8, DynmapIntegration.lineColor(claim.isAdminClaim()));
        marker.setFillStyle(0.2, DynmapIntegration.fillColor(claim.isAdminClaim()));
        marker.setRangeY((double)dim[4], (double)claim.getMaxY());
    }

    static void removeMarker(Claim claim) {
        if (markerSet == null) {
            return;
        }
        AreaMarker marker = markerSet.findAreaMarker(claim.getClaimID().toString());
        if (marker != null) {
            marker.deleteMarker();
        }
    }

    static void changeClaimName(Claim claim) {
        if (markerSet == null) {
            return;
        }
        markerSet.findAreaMarker(claim.getClaimID().toString()).setLabel(DynmapIntegration.claimLabel(claim));
    }

    static void changeClaimOwner(Claim claim) {
        if (markerSet == null) {
            return;
        }
        if (claim.getClaimName() == null || claim.getClaimName().isEmpty()) {
            markerSet.findAreaMarker(claim.getClaimID().toString()).setLabel(DynmapIntegration.claimLabel(claim));
        }
    }

    private static String getWorldName(class_1937 level) {
        class_5321 key = level.method_27983();
        if (key == class_1937.field_25179) {
            return level.method_8503().method_27728().method_150();
        }
        if (key == class_1937.field_25181) {
            return "DIM1";
        }
        if (key == class_1937.field_25180) {
            return "DIM-1";
        }
        return key.method_29177().method_12836() + "_" + key.method_29177().method_12832();
    }

    private static int lineColor(boolean admin) {
        return admin ? 11864329 : 16753152;
    }

    private static int fillColor(boolean admin) {
        return admin ? 0xFF0000 : 14737437;
    }

    private static String claimLabel(Claim claim) {
        String name = claim.getClaimName();
        if (name == null || name.isEmpty()) {
            if (claim.isAdminClaim()) {
                return "Admin Claim";
            }
            Optional prof = claim.getLevel().method_8503().method_3793().method_14512(claim.getOwner());
            return prof.map(GameProfile::getName).orElse("UNKOWN") + "'s Claim";
        }
        return name;
    }
}

