/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.player;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.data.IPlayerData;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.mixin.BannedEntryAccessor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_3218;
import net.minecraft.class_3335;
import net.minecraft.class_3336;
import net.minecraft.server.MinecraftServer;

public class OfflinePlayerData
implements IPlayerData {
    public final int claimBlocks;
    private int additionalClaimBlocks;
    public final LocalDateTime lastOnline;
    public final UUID owner;
    public final MinecraftServer server;
    public final Path save;

    public OfflinePlayerData(MinecraftServer server, UUID uuid) {
        this.save = ConfigHandler.getPlayerSavePath(server).resolve(String.valueOf(uuid) + ".json");
        int claim = ConfigHandler.config.startingBlocks;
        int add = 0;
        this.owner = uuid;
        LocalDateTime last = LocalDateTime.now();
        if (Files.exists(this.save, new LinkOption[0])) {
            try {
                JsonReader reader = ConfigHandler.GSON.newJsonReader((Reader)Files.newBufferedReader(this.save, StandardCharsets.UTF_8));
                JsonObject obj = (JsonObject)ConfigHandler.GSON.fromJson(reader, JsonObject.class);
                reader.close();
                if (obj == null) {
                    obj = new JsonObject();
                    Flan.error("Malformed json {}, using default values", uuid);
                }
                claim = ConfigHandler.fromJson(obj, "ClaimBlocks", claim);
                add = ConfigHandler.fromJson(obj, "AdditionalBlocks", add);
                if (obj.has("LastSeen")) {
                    last = LocalDateTime.parse(obj.get("LastSeen").getAsString(), Flan.ONLINE_TIME_FORMATTER);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                Flan.error("Error parsing time for {}, ignoring", uuid);
            }
        }
        this.claimBlocks = claim;
        this.additionalClaimBlocks = add;
        this.lastOnline = last;
        this.server = server;
    }

    @Override
    public int getClaimBlocks() {
        return this.claimBlocks;
    }

    @Override
    public int getAdditionalClaims() {
        return this.additionalClaimBlocks;
    }

    @Override
    public int usedClaimBlocks() {
        int usedClaimsBlocks = 0;
        for (class_3218 world : this.server.method_3738()) {
            Collection<Claim> claims = ClaimStorage.get(world).allClaimsFromPlayer(this.owner);
            if (claims == null) continue;
            usedClaimsBlocks += claims.stream().filter(claim -> !claim.isAdminClaim()).mapToInt(Claim::getPlane).sum();
        }
        return usedClaimsBlocks;
    }

    @Override
    public int remainingClaimBlocks() {
        return this.getClaimBlocks() + this.getAdditionalClaims() - this.usedClaimBlocks();
    }

    @Override
    public void setAdditionalClaims(int amount) {
        this.additionalClaimBlocks = amount;
        try {
            Files.createDirectories(this.save.getParent(), new FileAttribute[0]);
            if (!Files.exists(this.save, new LinkOption[0])) {
                Files.createFile(this.save, new FileAttribute[0]);
            }
            JsonReader reader = ConfigHandler.GSON.newJsonReader((Reader)Files.newBufferedReader(this.save, StandardCharsets.UTF_8));
            JsonObject obj = (JsonObject)ConfigHandler.GSON.fromJson(reader, JsonObject.class);
            reader.close();
            if (obj == null) {
                obj = new JsonObject();
                obj.addProperty("ClaimBlocks", (Number)this.claimBlocks);
                obj.addProperty("AdditionalBlocks", (Number)this.additionalClaimBlocks);
                obj.addProperty("LastSeen", this.lastOnline.format(Flan.ONLINE_TIME_FORMATTER));
                JsonObject defPerm = new JsonObject();
                obj.add("DefaultGroups", (JsonElement)defPerm);
            } else {
                obj.addProperty("AdditionalBlocks", (Number)this.additionalClaimBlocks);
            }
            Flan.debug("Attempting to write following json data {} to file {}", obj, this.save.getFileName());
            JsonWriter jsonWriter = ConfigHandler.GSON.newJsonWriter((Writer)Files.newBufferedWriter(this.save, StandardCharsets.UTF_8, new OpenOption[0]));
            ConfigHandler.GSON.toJson((JsonElement)obj, jsonWriter);
            jsonWriter.close();
        }
        catch (IOException e) {
            Flan.error("Error adding additional claimblocks to offline player {}", this.owner);
        }
    }

    public boolean isExpired(LocalDateTime now) {
        boolean banned;
        class_3336 entry = this.server.method_3793().method_14512(this.owner).map(arg_0 -> ((class_3335)this.server.method_3760().method_14563()).method_14640(arg_0)).orElse(null);
        boolean bl = banned = entry != null && entry.method_14502() == null;
        if (banned) {
            LocalDateTime bannedTime = LocalDateTime.ofInstant(((BannedEntryAccessor)entry).getCreationDate().toInstant(), ZoneId.systemDefault());
            return ConfigHandler.config.bannedDeletionTime != -1 && now.isAfter(bannedTime.plusDays(ConfigHandler.config.bannedDeletionTime));
        }
        return ConfigHandler.config.inactivityTime != -1 && now.isAfter(this.lastOnline.plusDays(ConfigHandler.config.inactivityTime)) && this.claimBlocks + this.additionalClaimBlocks < ConfigHandler.config.inactivityBlocksMax;
    }

    public void deleteFile() {
        try {
            Files.delete(this.save);
        }
        catch (IOException e) {
            Flan.error("Couldn't delete file player data of {}", this.owner);
            e.printStackTrace();
        }
    }
}

