/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.player.display;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ParticleIndicators;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.player.display.DisplayBox;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;

public class ClaimDisplay {
    private boolean initialDisplay;
    private int displayTime;
    private final int height;
    private final DisplayBox display;
    public final EnumDisplayType type;
    private int[][] corners;
    private int[][] middlePoss;
    private DisplayBox.Box prevDims;
    private final class_2390 corner;
    private final class_2390 middle;
    private final class_2248 displayBlock;

    public ClaimDisplay(Claim claim, EnumDisplayType type, int y) {
        this(claim.display(), (class_1937)claim.getLevel(), type, y);
    }

    public ClaimDisplay(DisplayBox display, class_1937 level, EnumDisplayType type, int y) {
        this.display = display;
        this.displayTime = ConfigHandler.config.claimDisplayTime;
        this.prevDims = display.box();
        this.type = type;
        this.height = Math.max(1 + level.method_31607(), y);
        switch (type) {
            case SUB: {
                this.corner = ParticleIndicators.SUBCLAIMCORNER;
                this.middle = ParticleIndicators.SUBCLAIMMIDDLE;
                this.displayBlock = class_2246.field_10085;
                break;
            }
            case CONFLICT: {
                this.corner = ParticleIndicators.OVERLAPCLAIM;
                this.middle = ParticleIndicators.OVERLAPCLAIM;
                this.displayBlock = class_2246.field_10002;
                break;
            }
            case EDIT: {
                this.corner = ParticleIndicators.EDITCLAIMCORNER;
                this.middle = ParticleIndicators.EDITCLAIMMIDDLE;
                this.displayBlock = class_2246.field_10441;
                break;
            }
            default: {
                this.corner = ParticleIndicators.CLAIMCORNER;
                this.middle = ParticleIndicators.CLAIMMIDDLE;
                this.displayBlock = class_2246.field_10205;
            }
        }
    }

    public boolean display(class_3222 player, boolean remove) {
        if (--this.displayTime % 2 == 0) {
            return this.display.isRemoved();
        }
        DisplayBox.Box dims = this.display.box();
        if (this.corners == null || this.changed(dims)) {
            this.onRemoved(player);
            HashMap<class_1923, class_2818> chunkCache = new HashMap<class_1923, class_2818>();
            this.middlePoss = ClaimDisplay.calculateDisplayPos(player.method_51469(), dims, this.height, this.display.excludedSides(), chunkCache);
            this.corners = this.calculateCorners(player.method_51469(), dims, chunkCache);
            this.initialDisplay = false;
        }
        if (ConfigHandler.config.particleDisplay) {
            for (int[] pos : this.corners) {
                if (pos[1] != pos[2]) {
                    player.field_13987.method_14364((class_2596)new class_2675((class_2394)this.corner, true, (double)pos[0] + 0.5, (double)pos[2] + 0.25, (double)pos[3] + 0.5, 0.0f, 0.5f, 0.0f, 0.0f, 1));
                }
                player.field_13987.method_14364((class_2596)new class_2675((class_2394)this.corner, true, (double)pos[0] + 0.5, (double)pos[1] + 0.25, (double)pos[3] + 0.5, 0.0f, 0.5f, 0.0f, 0.0f, 1));
            }
            if (this.middlePoss != null) {
                for (int[] pos : this.middlePoss) {
                    if (pos[1] != pos[2]) {
                        player.field_13987.method_14364((class_2596)new class_2675((class_2394)this.middle, true, (double)pos[0] + 0.5, (double)pos[2] + 0.25, (double)pos[3] + 0.5, 0.0f, 0.5f, 0.0f, 0.0f, 1));
                    }
                    player.field_13987.method_14364((class_2596)new class_2675((class_2394)this.middle, true, (double)pos[0] + 0.5, (double)pos[1] + 0.25, (double)pos[3] + 0.5, 0.0f, 0.5f, 0.0f, 0.0f, 1));
                }
            }
        } else if (!this.initialDisplay) {
            class_2338 blockPos;
            for (int[] pos : this.corners) {
                blockPos = new class_2338(pos[0], pos[1] != pos[2] ? pos[2] : pos[1], pos[3]);
                player.field_13987.method_14364((class_2596)new class_2626(blockPos.method_10074(), this.displayBlock.method_9564()));
            }
            if (this.middlePoss != null) {
                for (int[] pos : this.middlePoss) {
                    blockPos = new class_2338(pos[0], pos[1] != pos[2] ? pos[2] : pos[1], pos[3]);
                    player.field_13987.method_14364((class_2596)new class_2626(blockPos.method_10074(), this.displayBlock.method_9564()));
                }
            }
        }
        this.prevDims = dims;
        if (!this.initialDisplay) {
            this.initialDisplay = true;
        }
        return this.display.isRemoved() || remove && this.displayTime < 0;
    }

    public void onRemoved(class_3222 player) {
        if (!ConfigHandler.config.particleDisplay) {
            class_2338 blockPos;
            if (this.corners != null) {
                for (int[] pos : this.corners) {
                    blockPos = new class_2338(pos[0], pos[1] != pos[2] ? pos[2] : pos[1], pos[3]);
                    blockPos = blockPos.method_10074();
                    player.field_13987.method_14364((class_2596)new class_2626(blockPos, player.method_37908().method_8320(blockPos)));
                }
            }
            if (this.middlePoss != null) {
                for (int[] pos : this.middlePoss) {
                    blockPos = new class_2338(pos[0], pos[1] != pos[2] ? pos[2] : pos[1], pos[3]);
                    blockPos = blockPos.method_10074();
                    player.field_13987.method_14364((class_2596)new class_2626(blockPos, player.method_37908().method_8320(blockPos)));
                }
            }
        }
    }

    private int[][] calculateCorners(class_3218 level, DisplayBox.Box from, Map<class_1923, class_2818> chunkCache) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        int[] pos = ClaimDisplay.getPosFrom(level, from.minX(), from.minZ(), this.height, chunkCache);
        if (pos != null) {
            l.add(pos);
        }
        if ((pos = ClaimDisplay.getPosFrom(level, from.maxX(), from.minZ(), this.height, chunkCache)) != null) {
            l.add(pos);
        }
        if ((pos = ClaimDisplay.getPosFrom(level, from.minX(), from.maxZ(), this.height, chunkCache)) != null) {
            l.add(pos);
        }
        if ((pos = ClaimDisplay.getPosFrom(level, from.maxX(), from.maxZ(), this.height, chunkCache)) != null) {
            l.add(pos);
        }
        return (int[][])l.toArray((T[])new int[0][]);
    }

    private boolean changed(DisplayBox.Box dims) {
        return !this.prevDims.equals(dims);
    }

    public static int[][] calculateDisplayPos(class_3218 level, DisplayBox.Box from, int height, Set<class_2350> exclude, Map<class_1923, class_2818> chunkCache) {
        int[] pos;
        ArrayList<int[]> l = new ArrayList<int[]>();
        HashSet<Integer> xs = new HashSet<Integer>();
        ClaimDisplay.addEvenly(from.minX(), from.maxX(), 10, xs);
        xs.add(from.minX() + 1);
        xs.add(from.maxX() - 1);
        HashSet<Integer> zs = new HashSet<Integer>();
        ClaimDisplay.addEvenly(from.minZ(), from.maxZ(), 10, zs);
        zs.add(from.minZ() + 1);
        zs.add(from.maxZ() - 1);
        Iterator iterator = xs.iterator();
        while (iterator.hasNext()) {
            int x = (Integer)iterator.next();
            if (!exclude.contains(class_2350.field_11043) && (pos = ClaimDisplay.getPosFrom(level, x, from.minZ(), height, chunkCache)) != null) {
                l.add(pos);
            }
            if (exclude.contains(class_2350.field_11035) || (pos = ClaimDisplay.getPosFrom(level, x, from.maxZ(), height, chunkCache)) == null) continue;
            l.add(pos);
        }
        iterator = zs.iterator();
        while (iterator.hasNext()) {
            int z = (Integer)iterator.next();
            if (!exclude.contains(class_2350.field_11039) && (pos = ClaimDisplay.getPosFrom(level, from.minX(), z, height, chunkCache)) != null) {
                l.add(pos);
            }
            if (exclude.contains(class_2350.field_11034) || (pos = ClaimDisplay.getPosFrom(level, from.maxX(), z, height, chunkCache)) == null) continue;
            l.add(pos);
        }
        return (int[][])l.toArray((T[])new int[0][]);
    }

    private static void addEvenly(int min, int max, int step, Set<Integer> l) {
        if ((double)(max - min) < (double)step * 1.5) {
            return;
        }
        if (max - min > 0 && (double)(max - min) <= (double)step * 0.5) {
            l.add(max - step + 1);
            l.add(min + step - 1);
            return;
        }
        l.add(max - step);
        l.add(min + step);
        ClaimDisplay.addEvenly(min + step, max - step, step, l);
    }

    public static int[] getPosFrom(class_3218 level, int x, int z, int maxY, Map<class_1923, class_2818> chunkCache) {
        class_1923 pos = new class_1923(class_4076.method_18675((int)x), class_4076.method_18675((int)z));
        class_2818 chunk = chunkCache.computeIfAbsent(pos, k -> {
            if (!level.method_8393(pos.field_9181, pos.field_9180)) {
                return null;
            }
            return level.method_8497(pos.field_9181, pos.field_9180);
        });
        if (chunk == null) {
            return null;
        }
        int[] y = ClaimDisplay.nextAirAndWaterBlockFrom(chunk, x, maxY, z);
        return new int[]{x, y[0], y[1], z};
    }

    private static int[] nextAirAndWaterBlockFrom(class_2818 chunk, int x, int y, int z) {
        class_2338.class_2339 pos = new class_2338.class_2339(x, y, z);
        class_2680 state = chunk.method_8320((class_2338)pos);
        if (state.method_45474()) {
            boolean startedInLiquid = state.method_51176();
            boolean liquidCheck = false;
            int liquidHeight = pos.method_10264();
            while (state.method_45474() && !chunk.method_31606((class_2338)pos)) {
                pos.method_10100(0, -1, 0);
                state = chunk.method_8320((class_2338)pos);
                if (startedInLiquid || liquidCheck || !state.method_51176()) continue;
                liquidCheck = true;
                liquidHeight = pos.method_10264();
            }
            int[] yRet = new int[]{pos.method_10264() + 1, (liquidCheck ? liquidHeight : pos.method_10264()) + 1};
            if (startedInLiquid) {
                pos.method_10103(pos.method_10263(), liquidHeight + 1, pos.method_10260());
                state = chunk.method_8320((class_2338)pos);
                while (state.method_51176() && !chunk.method_31606((class_2338)pos)) {
                    pos.method_10100(0, 1, 0);
                    state = chunk.method_8320((class_2338)pos);
                }
                if (state.method_45474()) {
                    yRet[1] = pos.method_10264();
                }
            }
            return yRet;
        }
        while (!state.method_45474() && !chunk.method_31606((class_2338)pos)) {
            pos.method_10100(0, 1, 0);
            state = chunk.method_8320((class_2338)pos);
        }
        int[] yRet = new int[]{pos.method_10264(), pos.method_10264()};
        while (state.method_51176() && !chunk.method_31606((class_2338)pos)) {
            pos.method_10100(0, 1, 0);
            state = chunk.method_8320((class_2338)pos);
        }
        if (state.method_45474()) {
            yRet[1] = pos.method_10264();
        }
        return yRet;
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClaimDisplay) {
            return this.display.equals(((ClaimDisplay)obj).display);
        }
        return false;
    }
}

