/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1734;
import net.minecraft.class_479;
import net.minecraft.class_490;

public class Configs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "itemscroller.json";
    public static final Set<String> GUI_BLACKLIST = new HashSet<String>();
    public static final Set<String> SLOT_BLACKLIST = new HashSet<String>();

    public static void loadFromFile() {
        JsonElement element;
        File configFile = new File(FileUtils.getConfigDirectory(), CONFIG_FILE_NAME);
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = JsonUtils.parseJsonFile((File)configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Generic", Generic.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Hotkeys", Hotkeys.HOTKEY_LIST);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Toggles", Toggles.OPTIONS);
            Configs.getStrings(root, GUI_BLACKLIST, "guiBlacklist");
            Configs.getStrings(root, SLOT_BLACKLIST, "slotBlacklist");
        }
        CraftingHandler.clearDefinitions();
        CraftingHandler.addCraftingGridDefinition(class_479.class.getName(), class_1734.class.getName(), 0, new CraftingHandler.SlotRange(1, 9));
        CraftingHandler.addCraftingGridDefinition(class_490.class.getName(), class_1734.class.getName(), 0, new CraftingHandler.SlotRange(1, 4));
    }

    public static void saveToFile() {
        File dir = FileUtils.getConfigDirectory();
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            JsonObject root = new JsonObject();
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Generic", Generic.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Hotkeys", Hotkeys.HOTKEY_LIST);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Toggles", Toggles.OPTIONS);
            Configs.writeStrings(root, GUI_BLACKLIST, "guiBlacklist");
            Configs.writeStrings(root, SLOT_BLACKLIST, "slotBlacklist");
            JsonUtils.writeJsonToFile((JsonObject)root, (File)new File(dir, CONFIG_FILE_NAME));
        }
    }

    public void load() {
        Configs.loadFromFile();
    }

    public void save() {
        Configs.saveToFile();
    }

    private static void getStrings(JsonObject obj, Set<String> outputSet, String arrayName) {
        outputSet.clear();
        if (JsonUtils.hasArray((JsonObject)obj, (String)arrayName)) {
            JsonArray arr = obj.getAsJsonArray(arrayName);
            int size = arr.size();
            for (int i = 0; i < size; ++i) {
                outputSet.add(arr.get(i).getAsString());
            }
        }
    }

    private static void writeStrings(JsonObject obj, Set<String> inputSet, String arrayName) {
        if (!inputSet.isEmpty()) {
            JsonArray arr = new JsonArray();
            for (String str : inputSet) {
                arr.add(str);
            }
            obj.add(arrayName, (JsonElement)arr);
        }
    }

    public static class Generic {
        public static final ConfigBoolean CARPET_CTRL_Q_CRAFTING = (ConfigBoolean)new ConfigBoolean("carpetCtrlQCraftingEnabledOnServer", false, "itemscroller.config.generic.comment.carpetCtrlQCraftingEnabledOnServer").translatedName("itemscroller.config.generic.name.carpetCtrlQCraftingEnabledOnServer");
        public static final ConfigBoolean CLIENT_CRAFTING_FIX = (ConfigBoolean)new ConfigBoolean("clientCraftingFixOn1.12", true, "itemscroller.config.generic.comment.clientCraftingFixOn1_12").translatedName("itemscroller.config.generic.name.clientCraftingFixOn1_12");
        public static final ConfigBoolean CRAFTING_RENDER_RECIPE_ITEMS = (ConfigBoolean)new ConfigBoolean("craftingRenderRecipeItems", true, "itemscroller.config.generic.comment.craftingRenderRecipeItems").translatedName("itemscroller.config.generic.name.craftingRenderRecipeItems");
        public static final ConfigBoolean MOD_MAIN_TOGGLE = (ConfigBoolean)new ConfigBoolean("modMainToggle", true, "itemscroller.config.generic.comment.modMainToggle").translatedName("itemscroller.config.generic.name.modMainToggle");
        public static final ConfigBoolean MASS_CRAFT_INHIBIT_MID_UPDATES = (ConfigBoolean)new ConfigBoolean("massCraftInhibitMidUpdates", true, "itemscroller.config.generic.comment.massCraftInhibitMidUpdates").translatedName("itemscroller.config.generic.name.massCraftInhibitMidUpdates");
        public static final ConfigInteger MASS_CRAFT_INTERVAL = (ConfigInteger)new ConfigInteger("massCraftInterval", 2, 1, 60, "itemscroller.config.generic.comment.massCraftInterval").translatedName("itemscroller.config.generic.name.massCraftInterval");
        public static final ConfigInteger MASS_CRAFT_ITERATIONS = (ConfigInteger)new ConfigInteger("massCraftIterations", 36, 1, 256, "itemscroller.config.generic.comment.massCraftIterations").translatedName("itemscroller.config.generic.name.massCraftIterations");
        public static final ConfigBoolean MASS_CRAFT_SWAPS = (ConfigBoolean)new ConfigBoolean("massCraftSwapsOnly", false, "itemscroller.config.generic.comment.massCraftSwapsOnly").translatedName("itemscroller.config.generic.name.massCraftSwapsOnly");
        public static final ConfigBoolean MASS_CRAFT_RECIPE_BOOK = (ConfigBoolean)new ConfigBoolean("massCraftUseRecipeBook", false, "itemscroller.config.generic.comment.massCraftUseRecipeBook").translatedName("itemscroller.config.generic.name.massCraftUseRecipeBook");
        public static final ConfigInteger PACKET_RATE_LIMIT = (ConfigInteger)new ConfigInteger("packetRateLimit", 4, 1, 1024, "itemscroller.config.generic.comment.packetRateLimit").translatedName("itemscroller.config.generic.name.packetRateLimit");
        public static final ConfigBoolean SCROLL_CRAFT_STORE_RECIPES_TO_FILE = (ConfigBoolean)new ConfigBoolean("craftingRecipesSaveToFile", true, "itemscroller.config.generic.comment.craftingRecipesSaveToFile").translatedName("itemscroller.config.generic.name.craftingRecipesSaveToFile");
        public static final ConfigBoolean SCROLL_CRAFT_RECIPE_FILE_GLOBAL = (ConfigBoolean)new ConfigBoolean("craftingRecipesSaveFileIsGlobal", false, "itemscroller.config.generic.comment.craftingRecipesSaveFileIsGlobal").translatedName("itemscroller.config.generic.name.craftingRecipesSaveFileIsGlobal");
        public static final ConfigBoolean RATE_LIMIT_CLICK_PACKETS = (ConfigBoolean)new ConfigBoolean("rateLimitClickPackets", false, "itemscroller.config.generic.comment.rateLimitClickPackets").translatedName("itemscroller.config.generic.name.rateLimitClickPackets");
        public static final ConfigBoolean REVERSE_SCROLL_DIRECTION_SINGLE = (ConfigBoolean)new ConfigBoolean("reverseScrollDirectionSingle", false, "itemscroller.config.generic.comment.reverseScrollDirectionSingle").translatedName("itemscroller.config.generic.name.reverseScrollDirectionSingle");
        public static final ConfigBoolean REVERSE_SCROLL_DIRECTION_STACKS = (ConfigBoolean)new ConfigBoolean("reverseScrollDirectionStacks", false, "itemscroller.config.generic.comment.reverseScrollDirectionStacks").translatedName("itemscroller.config.generic.name.reverseScrollDirectionStacks");
        public static final ConfigBoolean USE_RECIPE_CACHING = (ConfigBoolean)new ConfigBoolean("useRecipeCaching", true, "itemscroller.config.generic.comment.useRecipeCaching").translatedName("itemscroller.config.generic.name.useRecipeCaching");
        public static final ConfigBoolean SLOT_POSITION_AWARE_SCROLL_DIRECTION = (ConfigBoolean)new ConfigBoolean("useSlotPositionAwareScrollDirection", false, "itemscroller.config.generic.comment.useSlotPositionAwareScrollDirection").translatedName("itemscroller.config.generic.name.useSlotPositionAwareScrollDirection");
        public static final ConfigBoolean VILLAGER_TRADE_USE_GLOBAL_FAVORITES = (ConfigBoolean)new ConfigBoolean("villagerTradeUseGlobalFavorites", true, "itemscroller.config.generic.comment.villagerTradeUseGlobalFavorites").translatedName("itemscroller.config.generic.name.villagerTradeUseGlobalFavorites");
        public static final ConfigBoolean VILLAGER_TRADE_LIST_REMEMBER_SCROLL = (ConfigBoolean)new ConfigBoolean("villagerTradeListRememberScrollPosition", true, "itemscroller.config.generic.comment.villagerTradeListRememberScrollPosition").translatedName("itemscroller.config.generic.name.villagerTradeListRememberScrollPosition");
        public static final ConfigBoolean SORT_ASSUME_EMPTY_BOX_STACKS = (ConfigBoolean)new ConfigBoolean("sortAssumeEmptyBoxStacks", true, "itemscroller.config.generic.comment.sortAssumeEmptyBoxStacks").translatedName("itemscroller.config.generic.name.sortAssumeEmptyBoxStacks");
        public static final ConfigBoolean SORT_SHULKER_BOXES_AT_END = (ConfigBoolean)new ConfigBoolean("sortShulkerBoxesAtEnd", true, "itemscroller.config.generic.comment.sortShulkerBoxesAtEnd").translatedName("itemscroller.config.generic.name.sortShulkerBoxesAtEnd");
        public static final ImmutableList<IConfigValue> OPTIONS = ImmutableList.of((Object)CARPET_CTRL_Q_CRAFTING, (Object)CLIENT_CRAFTING_FIX, (Object)CRAFTING_RENDER_RECIPE_ITEMS, (Object)MASS_CRAFT_INHIBIT_MID_UPDATES, (Object)MASS_CRAFT_INTERVAL, (Object)MASS_CRAFT_ITERATIONS, (Object)MASS_CRAFT_SWAPS, (Object)MASS_CRAFT_RECIPE_BOOK, (Object)MOD_MAIN_TOGGLE, (Object)PACKET_RATE_LIMIT, (Object)RATE_LIMIT_CLICK_PACKETS, (Object)SCROLL_CRAFT_STORE_RECIPES_TO_FILE, (Object[])new IConfigValue[]{SCROLL_CRAFT_RECIPE_FILE_GLOBAL, REVERSE_SCROLL_DIRECTION_SINGLE, REVERSE_SCROLL_DIRECTION_STACKS, SLOT_POSITION_AWARE_SCROLL_DIRECTION, USE_RECIPE_CACHING, VILLAGER_TRADE_USE_GLOBAL_FAVORITES, VILLAGER_TRADE_LIST_REMEMBER_SCROLL, SORT_ASSUME_EMPTY_BOX_STACKS, SORT_SHULKER_BOXES_AT_END});
    }

    public static class Toggles {
        public static final ConfigBoolean CRAFTING_FEATURES = (ConfigBoolean)new ConfigBoolean("enableCraftingFeatures", true, "itemscroller.config.toggles.comment.enableCraftingFeatures").translatedName("itemscroller.config.toggles.name.enableCraftingFeatures");
        public static final ConfigBoolean DROP_MATCHING = (ConfigBoolean)new ConfigBoolean("enableDropkeyDropMatching", true, "itemscroller.config.toggles.comment.enableDropkeyDropMatching").translatedName("itemscroller.config.toggles.name.enableDropkeyDropMatching");
        public static final ConfigBoolean RIGHT_CLICK_CRAFT_STACK = (ConfigBoolean)new ConfigBoolean("enableRightClickCraftingOneStack", true, "itemscroller.config.toggles.comment.enableRightClickCraftingOneStack").translatedName("itemscroller.config.toggles.name.enableRightClickCraftingOneStack");
        public static final ConfigBoolean SCROLL_EVERYTHING = (ConfigBoolean)new ConfigBoolean("enableScrollingEverything", true, "itemscroller.config.toggles.comment.enableScrollingEverything").translatedName("itemscroller.config.toggles.name.enableScrollingEverything");
        public static final ConfigBoolean SCROLL_MATCHING = (ConfigBoolean)new ConfigBoolean("enableScrollingMatchingStacks", true, "itemscroller.config.toggles.comment.enableScrollingMatchingStacks").translatedName("itemscroller.config.toggles.name.enableScrollingMatchingStacks");
        public static final ConfigBoolean SCROLL_SINGLE = (ConfigBoolean)new ConfigBoolean("enableScrollingSingle", true, "itemscroller.config.toggles.comment.enableScrollingSingle").translatedName("itemscroller.config.toggles.name.enableScrollingSingle");
        public static final ConfigBoolean SCROLL_STACKS = (ConfigBoolean)new ConfigBoolean("enableScrollingStacks", true, "itemscroller.config.toggles.comment.enableScrollingStacks").translatedName("itemscroller.config.toggles.name.enableScrollingStacks");
        public static final ConfigBoolean SCROLL_STACKS_FALLBACK = (ConfigBoolean)new ConfigBoolean("enableScrollingStacksFallback", true, "itemscroller.config.toggles.comment.enableScrollingStacksFallback").translatedName("itemscroller.config.toggles.name.enableScrollingStacksFallback");
        public static final ConfigBoolean SCROLL_VILLAGER = (ConfigBoolean)new ConfigBoolean("enableScrollingVillager", true, "itemscroller.config.toggles.comment.enableScrollingVillager").translatedName("itemscroller.config.toggles.name.enableScrollingVillager");
        public static final ConfigBoolean SHIFT_DROP_ITEMS = (ConfigBoolean)new ConfigBoolean("enableShiftDropItems", true, "itemscroller.config.toggles.comment.enableShiftDropItems").translatedName("itemscroller.config.toggles.name.enableShiftDropItems");
        public static final ConfigBoolean SHIFT_PLACE_ITEMS = (ConfigBoolean)new ConfigBoolean("enableShiftPlaceItems", true, "itemscroller.config.toggles.comment.enableShiftPlaceItems").translatedName("itemscroller.config.toggles.name.enableShiftPlaceItems");
        public static final ConfigBoolean VILLAGER_TRADE_FEATURES = (ConfigBoolean)new ConfigBoolean("enableVillagerTradeFeatures", true, "itemscroller.config.toggles.comment.enableVillagerTradeFeatures").translatedName("itemscroller.config.toggles.name.enableVillagerTradeFeatures");
        public static final ImmutableList<IConfigValue> OPTIONS = ImmutableList.of((Object)CRAFTING_FEATURES, (Object)DROP_MATCHING, (Object)RIGHT_CLICK_CRAFT_STACK, (Object)SCROLL_EVERYTHING, (Object)SCROLL_MATCHING, (Object)SCROLL_SINGLE, (Object)SCROLL_STACKS, (Object)SCROLL_STACKS_FALLBACK, (Object)SCROLL_VILLAGER, (Object)SHIFT_DROP_ITEMS, (Object)SHIFT_PLACE_ITEMS, (Object)VILLAGER_TRADE_FEATURES, (Object[])new IConfigValue[0]);
    }
}

